/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.fluids.tank;

import com.google.common.util.concurrent.Runnables;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableInt;
import plus.dragons.createdragonsplus.util.CodeReference;

@CodeReference(value={SmartFluidTankBehaviour.class}, source={"create"}, license={"mit"})
public class FluidTankBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<FluidTankBehaviour> TYPE = new BehaviourType();
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    protected SmartFluidTank[] handlers;
    protected TankSegment[] tanks;
    protected IFluidHandler capability;
    protected Runnable fluidUpdateCallback;

    public FluidTankBehaviour(SmartBlockEntity blockEntity, List<TankFactory> factories, boolean enforceVariety) {
        super(blockEntity);
        this.handlers = new SmartFluidTank[factories.size()];
        this.tanks = new TankSegment[factories.size()];
        for (int i = 0; i < factories.size(); ++i) {
            TankSegment tankSegment;
            this.tanks[i] = tankSegment = new TankSegment(factories.get(i));
            this.handlers[i] = tankSegment.tank;
        }
        this.capability = (IFluidHandler)Util.make((Object)new CombinedTankWrapper((IFluidHandler[])this.handlers), tank -> {
            if (enforceVariety) {
                tank.enforceVariety();
            }
        });
        this.fluidUpdateCallback = Runnables.doNothing();
    }

    public FluidTankBehaviour(SmartBlockEntity blockEntity, TankFactory factory) {
        super(blockEntity);
        TankSegment tank = new TankSegment(factory);
        this.handlers = new SmartFluidTank[]{tank.tank};
        this.tanks = new TankSegment[]{tank};
        this.capability = tank.tank;
        this.fluidUpdateCallback = Runnables.doNothing();
    }

    public FluidTankBehaviour whenFluidUpdates(Runnable fluidUpdateCallback) {
        this.fluidUpdateCallback = fluidUpdateCallback;
        return this;
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void initialize() {
        super.initialize();
        if (this.getWorld().isClientSide) {
            return;
        }
        this.forEach(segment -> {
            segment.fluidLevel.forceNextSync();
            segment.onFluidStackChanged();
        });
    }

    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.updateFluids();
            }
        }
        this.forEach(segment -> segment.getFluidLevel().tickChaser());
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.updateFluids();
    }

    public void sendDataLazily() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        this.updateFluids();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    protected void updateFluids() {
        this.fluidUpdateCallback.run();
        this.blockEntity.sendData();
        this.blockEntity.setChanged();
    }

    public void unload() {
        super.unload();
        Level level = this.blockEntity.getLevel();
        assert (level != null);
        level.invalidateCapabilities(this.getPos());
    }

    public SmartFluidTank getPrimaryHandler() {
        return this.handlers[0];
    }

    public TankSegment getPrimaryTank() {
        return this.tanks[0];
    }

    public SmartFluidTank[] getHandlers() {
        return this.handlers;
    }

    public TankSegment[] getTanks() {
        return this.tanks;
    }

    public void setTank(int index, TankFactory factory) {
        TankSegment tank = this.tanks[index] = new TankSegment(factory);
        this.handlers[index] = tank.tank;
        this.updateFluids();
    }

    public boolean isEmpty() {
        for (TankSegment tankSegment : this.tanks) {
            if (tankSegment.tank.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void forEach(Consumer<TankSegment> action) {
        for (TankSegment tankSegment : this.tanks) {
            action.accept(tankSegment);
        }
    }

    public IFluidHandler getCapability() {
        return this.capability;
    }

    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(nbt, registries, clientPacket);
        ListTag tanksNBT = new ListTag();
        this.forEach(segment -> tanksNBT.add((Object)segment.writeNBT(registries)));
        nbt.put(this.getType().getName() + "Tanks", (Tag)tanksNBT);
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(nbt, registries, clientPacket);
        MutableInt index = new MutableInt(0);
        NBTHelper.iterateCompoundList((ListTag)nbt.getList(this.getType().getName() + "Tanks", 10), tank -> {
            if (index.intValue() >= this.tanks.length) {
                return;
            }
            this.tanks[index.intValue()].readNBT((CompoundTag)tank, registries, clientPacket);
            index.increment();
        });
    }

    public class TankSegment {
        public final SmartFluidTank tank;
        protected LerpedFloat fluidLevel;
        protected FluidStack renderedFluid;

        public TankSegment(TankFactory factory) {
            this.tank = factory.create(fluid -> this.onFluidStackChanged());
            this.fluidLevel = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.25, LerpedFloat.Chaser.EXP);
            this.renderedFluid = FluidStack.EMPTY;
        }

        public void onFluidStackChanged() {
            if (!FluidTankBehaviour.this.blockEntity.hasLevel()) {
                return;
            }
            this.fluidLevel.chase((double)((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity()), 0.25, LerpedFloat.Chaser.EXP);
            if (!FluidTankBehaviour.this.getWorld().isClientSide) {
                FluidTankBehaviour.this.sendDataLazily();
            }
            if (FluidTankBehaviour.this.blockEntity.isVirtual() && !this.tank.getFluid().isEmpty()) {
                this.renderedFluid = this.tank.getFluid();
            }
        }

        public FluidStack getRenderedFluid() {
            return this.renderedFluid;
        }

        public LerpedFloat getFluidLevel() {
            return this.fluidLevel;
        }

        public float getTotalUnits(float partialTicks) {
            return this.fluidLevel.getValue(partialTicks) * (float)this.tank.getCapacity();
        }

        public CompoundTag writeNBT(HolderLookup.Provider registries) {
            CompoundTag compound = new CompoundTag();
            compound.put("TankContent", (Tag)this.tank.writeToNBT(registries, new CompoundTag()));
            compound.put("Level", (Tag)this.fluidLevel.writeNBT());
            return compound;
        }

        public void readNBT(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
            this.tank.readFromNBT(registries, compound.getCompound("TankContent"));
            this.fluidLevel.readNBT(compound.getCompound("Level"), clientPacket);
            if (!this.tank.getFluid().isEmpty()) {
                this.renderedFluid = this.tank.getFluid();
            }
        }

        public boolean isEmpty(float partialTicks) {
            FluidStack renderedFluid = this.getRenderedFluid();
            if (renderedFluid.isEmpty()) {
                return true;
            }
            float units = this.getTotalUnits(partialTicks);
            return units < 1.0f;
        }
    }

    @FunctionalInterface
    public static interface TankFactory {
        public SmartFluidTank create(Consumer<FluidStack> var1);
    }
}

