/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.advancements;

import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import plus.dragons.createdragonsplus.common.advancements.criterion.BuiltinTrigger;
import plus.dragons.createdragonsplus.common.advancements.criterion.StatTrigger;
import plus.dragons.createdragonsplus.util.CodeReference;

@CodeReference(value={CreateAdvancement.class}, source={"create"}, license={"mit"})
public abstract class CDPAdvancement {
    static final String SECRET_SUFFIX = "\n\u00a77(Hidden Advancement)";
    private final Advancement.Builder mcBuilder = Advancement.Builder.advancement();
    private BuiltinTrigger builtinTrigger;
    private CDPAdvancement parent;
    private final Builder createBuilder = new Builder();
    AdvancementHolder datagenResult;
    private String id;
    private String title;
    private String description;

    public CDPAdvancement(String id, UnaryOperator<Builder> b) {
        this.id = id;
        b.apply(this.createBuilder);
        if (!this.createBuilder.externalTrigger) {
            this.builtinTrigger = this.add(this.asResource(id));
            this.mcBuilder.addCriterion("0", this.builtinTrigger.createCriterion(this.builtinTrigger));
        }
        if (this.createBuilder.type == TaskType.SECRET) {
            this.description = this.description + SECRET_SUFFIX;
        }
        this.addToAdvancementEntries();
    }

    protected abstract BuiltinTrigger add(ResourceLocation var1);

    protected abstract void addToAdvancementEntries();

    protected abstract ResourceLocation getBackground();

    protected abstract String namespace();

    private String titleKey() {
        return "advancement." + this.namespace() + "." + this.id;
    }

    private String descriptionKey() {
        return this.titleKey() + ".desc";
    }

    public boolean isAlreadyAwardedTo(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer sp = (ServerPlayer)player;
        AdvancementHolder advancement = sp.getServer().getAdvancements().get(this.asResource(this.id));
        if (advancement == null) {
            return true;
        }
        return sp.getAdvancements().getOrStartProgress(advancement).isDone();
    }

    public BuiltinTrigger builtinTrigger() {
        if (this.builtinTrigger == null) {
            throw new UnsupportedOperationException("Advancement " + this.id + " uses external Triggers");
        }
        return this.builtinTrigger;
    }

    private ResourceLocation asResource(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)this.namespace(), (String)id);
    }

    public void awardTo(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (this.builtinTrigger == null) {
            throw new UnsupportedOperationException("Advancement " + this.id + " uses external Triggers, it cannot be awarded directly");
        }
        this.builtinTrigger.trigger(sp);
    }

    public void save(Consumer<AdvancementHolder> t, HolderLookup.Provider registries) {
        if (this.parent != null) {
            this.mcBuilder.parent(this.parent.datagenResult);
        }
        if (this.createBuilder.func != null) {
            this.createBuilder.icon(this.createBuilder.func.apply(registries));
        }
        this.mcBuilder.display(this.createBuilder.icon, (Component)Component.translatable((String)this.titleKey()), (Component)Component.translatable((String)this.descriptionKey()).withStyle(s -> s.withColor(14393875)), this.id.equals("root") ? this.getBackground() : null, this.createBuilder.type.advancementType, this.createBuilder.type.toast, this.createBuilder.type.announce, this.createBuilder.type.hide);
        this.datagenResult = this.mcBuilder.save(t, this.asResource(this.id).toString());
    }

    public void provideLang(BiConsumer<String, String> consumer) {
        consumer.accept(this.titleKey(), this.title);
        consumer.accept(this.descriptionKey(), this.description);
    }

    public class Builder {
        private TaskType type = TaskType.NORMAL;
        private boolean externalTrigger;
        private int keyIndex;
        private ItemStack icon;
        private Function<HolderLookup.Provider, ItemStack> func;

        public Builder special(TaskType type) {
            this.type = type;
            return this;
        }

        public Builder after(CDPAdvancement other) {
            CDPAdvancement.this.parent = other;
            return this;
        }

        public Builder icon(ItemProviderEntry<?, ?> item) {
            return this.icon(item.asStack());
        }

        public Builder icon(ItemLike item) {
            return this.icon(new ItemStack(item));
        }

        public Builder icon(ItemStack stack) {
            this.icon = stack;
            return this;
        }

        public Builder icon(Function<HolderLookup.Provider, ItemStack> func) {
            this.func = func;
            return this;
        }

        public Builder title(String title) {
            CDPAdvancement.this.title = title;
            return this;
        }

        public Builder description(String description) {
            CDPAdvancement.this.description = description;
            return this;
        }

        public Builder whenBlockPlaced(Block block) {
            return this.externalTrigger(ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)block));
        }

        public Builder whenIconCollected() {
            return this.externalTrigger(InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{this.icon.getItem()}));
        }

        public Builder whenItemCollected(ItemProviderEntry<?, ?> item) {
            return this.whenItemCollected((ItemLike)item.asStack().getItem());
        }

        public Builder whenItemCollected(ItemLike itemProvider) {
            return this.externalTrigger(InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{itemProvider}));
        }

        public Builder whenStatReach(Stat<?> stat, MinMaxBounds.Ints bounds) {
            return this.externalTrigger(StatTrigger.Instance.of(stat, bounds));
        }

        public Builder whenItemCollected(TagKey<Item> tag) {
            return this.externalTrigger(InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(tag).build()}));
        }

        public Builder awardedForFree() {
            return this.externalTrigger(InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[0]));
        }

        public Builder externalTrigger(Criterion<?> trigger) {
            CDPAdvancement.this.mcBuilder.addCriterion(String.valueOf(this.keyIndex), trigger);
            this.externalTrigger = true;
            ++this.keyIndex;
            return this;
        }
    }

    public static enum TaskType {
        SILENT(AdvancementType.TASK, false, false, false),
        NORMAL(AdvancementType.TASK, true, false, false),
        NOISY(AdvancementType.TASK, true, true, false),
        EXPERT(AdvancementType.GOAL, true, true, false),
        SECRET(AdvancementType.GOAL, true, true, true);

        private final AdvancementType advancementType;
        private final boolean toast;
        private final boolean announce;
        private final boolean hide;

        private TaskType(AdvancementType advancementType, boolean toast, boolean announce, boolean hide) {
            this.advancementType = advancementType;
            this.toast = toast;
            this.announce = announce;
            this.hide = hide;
        }
    }
}

