/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.displayLink.source;

import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.NumericSingleLineDisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.content.redstone.smartObserver.SmartObserverBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class ItemCountDisplaySource
extends NumericSingleLineDisplaySource {
    @Override
    protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        BlockEntity sourceBE = context.getSourceBlockEntity();
        if (!(sourceBE instanceof SmartObserverBlockEntity)) {
            return ZERO.copy();
        }
        SmartObserverBlockEntity cobe = (SmartObserverBlockEntity)sourceBE;
        InvManipulationBehaviour invManipulationBehaviour = cobe.getBehaviour(InvManipulationBehaviour.TYPE);
        FilteringBehaviour filteringBehaviour = cobe.getBehaviour(FilteringBehaviour.TYPE);
        IItemHandler handler = (IItemHandler)invManipulationBehaviour.getInventory();
        if (handler == null) {
            return ZERO.copy();
        }
        int collected = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.extractItem(i, handler.getSlotLimit(i), true);
            if (stack.isEmpty() || !filteringBehaviour.test(stack)) continue;
            collected += stack.getCount();
        }
        return Component.literal((String)String.valueOf(collected));
    }

    @Override
    protected String getTranslationKey() {
        return "count_items";
    }

    @Override
    protected boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }
}

