/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.redstoneRequester;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.WiFiParticle;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterEffectPacket;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterMenu;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.content.logistics.stockTicker.StockCheckingBlockEntity;
import net.createmod.catnip.codecs.CatnipCodecUtils;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;

public class RedstoneRequesterBlockEntity
extends StockCheckingBlockEntity
implements MenuProvider {
    public boolean allowPartialRequests = false;
    public PackageOrderWithCrafts encodedRequest = PackageOrderWithCrafts.empty();
    public String encodedTargetAdress = "";
    public boolean lastRequestSucceeded;
    protected boolean redstonePowered;

    public RedstoneRequesterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void onRedstonePowerChanged() {
        boolean hasNeighborSignal = this.level.hasNeighborSignal(this.worldPosition);
        if (this.redstonePowered == hasNeighborSignal) {
            return;
        }
        this.lastRequestSucceeded = false;
        if (hasNeighborSignal) {
            this.triggerRequest();
        }
        this.redstonePowered = hasNeighborSignal;
        this.notifyUpdate();
    }

    public void triggerRequest() {
        if (this.encodedRequest.isEmpty()) {
            return;
        }
        boolean anySucceeded = false;
        InventorySummary summaryOfOrder = new InventorySummary();
        this.encodedRequest.stacks().forEach(summaryOfOrder::add);
        InventorySummary summary = this.getAccurateSummary();
        for (BigItemStack entry : summaryOfOrder.getStacks()) {
            Level level;
            if (summary.getCountOf(entry.stack) >= entry.count) {
                anySucceeded = true;
                continue;
            }
            if (this.allowPartialRequests || !((level = this.level) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            CatnipServices.NETWORK.sendToClientsAround(serverLevel, (Vec3i)this.worldPosition, 32.0, (CustomPacketPayload)new RedstoneRequesterEffectPacket(this.worldPosition, false));
            return;
        }
        this.broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType.REDSTONE, this.encodedRequest, null, this.encodedTargetAdress);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CatnipServices.NETWORK.sendToClientsAround(serverLevel, (Vec3i)this.worldPosition, 32.0, (CustomPacketPayload)new RedstoneRequesterEffectPacket(this.worldPosition, anySucceeded));
        }
        this.lastRequestSucceeded = true;
    }

    @Override
    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.redstonePowered = tag.getBoolean("Powered");
        this.lastRequestSucceeded = tag.getBoolean("Success");
        this.allowPartialRequests = tag.getBoolean("AllowPartial");
        this.encodedRequest = CatnipCodecUtils.decode(PackageOrderWithCrafts.CODEC, (HolderLookup.Provider)registries, (Tag)tag.getCompound("EncodedRequest")).orElse(PackageOrderWithCrafts.empty());
        this.encodedTargetAdress = tag.getString("EncodedAddress");
    }

    @Override
    public void writeSafe(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeSafe(tag, registries);
        tag.putBoolean("AllowPartial", this.allowPartialRequests);
        tag.putString("EncodedAddress", this.encodedTargetAdress);
        tag.put("EncodedRequest", (Tag)CatnipCodecUtils.encode(PackageOrderWithCrafts.CODEC, (HolderLookup.Provider)registries, (Object)this.encodedRequest).orElseThrow());
    }

    @Override
    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.putBoolean("Powered", this.redstonePowered);
        tag.putBoolean("Success", this.lastRequestSucceeded);
        tag.putBoolean("AllowPartial", this.allowPartialRequests);
        tag.putString("EncodedAddress", this.encodedTargetAdress);
        tag.put("EncodedRequest", (Tag)CatnipCodecUtils.encode(PackageOrderWithCrafts.CODEC, (HolderLookup.Provider)registries, (Object)this.encodedRequest).orElseThrow());
    }

    public InteractionResult use(Player player) {
        if (player == null || player.isCrouching()) {
            return InteractionResult.PASS;
        }
        if (player instanceof FakePlayer) {
            return InteractionResult.PASS;
        }
        if (this.level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (!this.behaviour.mayInteractMessage(player)) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu((MenuProvider)this, this.worldPosition);
        return InteractionResult.SUCCESS;
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return RedstoneRequesterMenu.create(pContainerId, pPlayerInventory, this);
    }

    public void playEffect(boolean success) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)this.worldPosition);
        if (success) {
            AllSoundEvents.CONFIRM.playAt(this.level, (Vec3i)this.worldPosition, 0.5f, 1.5f, false);
            AllSoundEvents.STOCK_LINK.playAt(this.level, (Vec3i)this.worldPosition, 1.0f, 1.0f, false);
            this.level.addParticle((ParticleOptions)new WiFiParticle.Data(), vec3.x, vec3.y, vec3.z, 1.0, 1.0, 1.0);
        } else {
            AllSoundEvents.DENY.playAt(this.level, (Vec3i)this.worldPosition, 0.5f, 1.0f, false);
            this.level.addParticle((ParticleOptions)ParticleTypes.ENCHANTED_HIT, vec3.x, vec3.y + 1.0, vec3.z, 0.0, 0.0, 0.0);
        }
    }
}

