/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.WorldUtils;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record TeleportToPlayerMessage(String name) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TeleportToPlayerMessage> TYPE = new CustomPacketPayload.Type(CrashUtils.ResourceLocation("teleporttoplayermessage"));
    public static final StreamCodec<? super RegistryFriendlyByteBuf, TeleportToPlayerMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, TeleportToPlayerMessage::name, TeleportToPlayerMessage::new);

    public static TeleportToPlayerMessage decode(FriendlyByteBuf buf) {
        return new TeleportToPlayerMessage(buf.readUtf(100));
    }

    public static void handle(TeleportToPlayerMessage data, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        if (!player.hasPermissions(2)) {
            return;
        }
        Level ori = player.getCommandSenderWorld();
        AtomicReference dest = new AtomicReference();
        AtomicReference otherPos = new AtomicReference();
        WorldUtils.applyToPlayer(data.name, player.server, o -> {
            dest.set(o.getCommandSenderWorld());
            otherPos.set(o.blockPosition());
        });
        if (otherPos.get() == null) {
            CommandUtils.sendMessageToPlayer((Player)player, "Failed to load Player");
        }
        WorldUtils.teleportPlayer((Player)player, ori, (Level)dest.get(), (BlockPos)otherPos.get());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

