/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CraftStackMessage
implements CustomPacketPayload {
    public static CustomPacketPayload.Type<CraftStackMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"craftingtweaks", (String)"craft_stack"));
    private final int slotNumber;

    public CraftStackMessage(int slotId) {
        this.slotNumber = slotId;
    }

    public static CraftStackMessage decode(FriendlyByteBuf buf) {
        byte slotNumber = buf.readByte();
        return new CraftStackMessage(slotNumber);
    }

    public static void encode(FriendlyByteBuf buf, CraftStackMessage message) {
        buf.writeByte(message.slotNumber);
    }

    public static void handle(ServerPlayer player, CraftStackMessage message) {
        if (player == null) {
            return;
        }
        AbstractContainerMenu menu = player.containerMenu;
        if (menu == null || message.slotNumber < 0 || message.slotNumber >= menu.slots.size()) {
            return;
        }
        Slot mouseSlot = (Slot)menu.slots.get(message.slotNumber);
        ItemStack mouseStack = menu.getCarried();
        for (int maxTries = 64; maxTries > 0 && mouseSlot.hasItem() && (mouseStack.isEmpty() || mouseStack.getCount() + mouseSlot.getItem().getCount() <= mouseStack.getMaxStackSize()); --maxTries) {
            menu.clicked(mouseSlot.index, 0, ClickType.PICKUP, (Player)player);
            mouseStack = menu.getCarried();
        }
        player.connection.send((Packet)new ClientboundContainerSetSlotPacket(-1, -1, -1, menu.getCarried()));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

