/*
 * Decompiled with CFR 0.152.
 */
package net.countered.terrainslabs.worldgen.slabfeature;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Set;
import net.countered.terrainslabs.block.ModBlocksRegistry;
import net.countered.terrainslabs.block.ModSlabsMap;
import net.countered.terrainslabs.config.MyModConfig;
import net.countered.terrainslabs.persistence.SlabChunkAttachment;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_5281;
import net.minecraft.class_5821;

public class SlabFeatureLogic
extends class_3031<class_3111> {
    public static final Set<class_2248> SOIL_SLAB_BLOCKS = Set.of(ModBlocksRegistry.GRASS_SLAB, ModBlocksRegistry.PODZOL_SLAB, ModBlocksRegistry.MYCELIUM_SLAB, ModBlocksRegistry.PATH_SLAB);

    public SlabFeatureLogic(Codec<class_3111> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        if (MyModConfig.enableSlabGeneration) {
            this.storeSlabPositions(context);
            return true;
        }
        return false;
    }

    private void storeSlabPositions(class_5821<class_3111> context) {
        class_5281 worldAccess = context.method_33652();
        class_2338 origin = context.method_33655();
        class_1923 chunkPos = new class_1923(origin);
        class_2791 chunk = worldAccess.method_8392(chunkPos.field_9181, chunkPos.field_9180);
        class_2338 highestBlock = this.findHighestChunkPos((class_1936)worldAccess, chunkPos);
        for (int y = worldAccess.method_31607(); y < highestBlock.method_10264() + 1; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    class_2680 currentBlockState;
                    class_2338 currentPos = chunkPos.method_35231(x, y, z);
                    class_2338 blockBelowPos = currentPos.method_10074();
                    class_2338 blockAbovePos = currentPos.method_10084();
                    class_2680 blockBelowState = worldAccess.method_8320(blockBelowPos);
                    class_2680 blockAboveState = worldAccess.method_8320(blockAbovePos);
                    if (this.shouldPlaceBottomSlab((class_1936)worldAccess, currentPos, blockAboveState, blockBelowState, currentBlockState = worldAccess.method_8320(currentPos))) {
                        ((List)chunk.getAttachedOrCreate(SlabChunkAttachment.BOT_SLAB_POSITIONS)).add(currentPos);
                        continue;
                    }
                    if (!this.shouldPlaceTopSlab((class_1936)worldAccess, currentPos, currentBlockState, blockBelowState, blockAboveState, blockAbovePos)) continue;
                    ((List)chunk.getAttachedOrCreate(SlabChunkAttachment.TOP_SLAB_POSITIONS)).add(currentPos);
                }
            }
        }
    }

    private class_2338 findHighestChunkPos(class_1936 worldAccess, class_1923 chunkPos) {
        class_2338.class_2339 highestChunkPos = new class_2338.class_2339(0, 0, 0);
        class_2338.class_2339 testPos = new class_2338.class_2339(0, 0, 0);
        for (int x = chunkPos.method_8326(); x <= chunkPos.method_8327(); ++x) {
            for (int z = chunkPos.method_8328(); z <= chunkPos.method_8329(); ++z) {
                testPos.method_10103(x, 0, z);
                class_2338 topPosition = worldAccess.method_8598(class_2902.class_2903.field_13194, (class_2338)testPos);
                if (highestChunkPos.method_10264() >= topPosition.method_10264()) continue;
                highestChunkPos = topPosition.method_25503();
            }
        }
        return highestChunkPos;
    }

    private boolean shouldPlaceBottomSlab(class_1936 world, class_2338 currentPos, class_2680 blockAboveState, class_2680 blockBelowState, class_2680 currentBlockState) {
        if (currentBlockState.method_26216((class_1922)world, currentPos) && !currentBlockState.method_27852(class_2246.field_10477) && !currentBlockState.method_45474() || ModSlabsMap.getSlabForBlock(blockBelowState.method_26204()) == class_2246.field_10124 || !blockAboveState.method_27852(class_2246.field_10124) && !blockAboveState.method_27852(class_2246.field_10382) && !blockAboveState.method_27852(class_2246.field_10543) && !blockAboveState.method_27852(class_2246.field_10243)) {
            return false;
        }
        return this.validSurroundingBottom(world, currentPos);
    }

    private boolean shouldPlaceTopSlab(class_1936 world, class_2338 currentPos, class_2680 currentState, class_2680 blockBelow, class_2680 blockAboveState, class_2338 blockAbovePos) {
        if (!currentState.method_26216((class_1922)world, currentPos) || !blockBelow.method_27852(class_2246.field_10124) && !blockBelow.method_27852(class_2246.field_10382) && !blockBelow.method_27852(class_2246.field_10543) && !blockBelow.method_27852(class_2246.field_10243) || ModSlabsMap.getSlabForBlock(blockAboveState.method_26204()).equals(class_2246.field_10124)) {
            return false;
        }
        return this.validSurroundingTop(world, currentPos);
    }

    private boolean validSurroundingTop(class_1936 world, class_2338 currentPos) {
        boolean topOfCeiling = false;
        boolean validNeighbors = false;
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            boolean isBelowOppositeStateNotOpaque;
            class_2338 neighborPos = currentPos.method_10093(direction);
            class_2338 aboveNeighborPos = neighborPos.method_10084();
            class_2338 oppositePos = currentPos.method_10093(direction.method_10153());
            class_2338 belowOppositePos = oppositePos.method_10074();
            class_2680 neighborState = world.method_8320(neighborPos);
            class_2680 aboveNeighborState = world.method_8320(aboveNeighborPos);
            class_2680 oppositeState = world.method_8320(oppositePos);
            class_2680 belowOppositeState = world.method_8320(belowOppositePos);
            if (neighborState.method_27852(class_2246.field_28411) || neighborState.method_27852(class_2246.field_10164)) {
                return false;
            }
            boolean isNeighborStateNotOpaque = !neighborState.method_26216((class_1922)world, neighborPos);
            boolean isOppositeStateOpaque = oppositeState.method_26216((class_1922)world, oppositePos);
            boolean isAboveNeighborStateOpaque = aboveNeighborState.method_26216((class_1922)world, aboveNeighborPos);
            boolean bl = isBelowOppositeStateNotOpaque = !belowOppositeState.method_26216((class_1922)world, belowOppositePos);
            if (isNeighborStateNotOpaque && isOppositeStateOpaque && isBelowOppositeStateNotOpaque) {
                topOfCeiling = true;
            }
            if (!neighborState.method_27852(class_2246.field_10124) && !neighborState.method_27852(class_2246.field_10382) && !neighborState.method_27852(class_2246.field_10543) && !neighborState.method_27852(class_2246.field_10243)) continue;
            validNeighbors = true;
        }
        return topOfCeiling && validNeighbors;
    }

    private boolean validSurroundingBottom(class_1936 world, class_2338 currentPos) {
        boolean bottomOfMountain = false;
        boolean validNeighbors = false;
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            boolean isOppositeDirNoSnow;
            class_2338 neighborPos = currentPos.method_10093(direction);
            class_2338 belowNeighborPos = neighborPos.method_10074();
            class_2338 oppositePos = currentPos.method_10093(direction.method_10153());
            class_2680 neighborState = world.method_8320(neighborPos);
            class_2680 belowNeighborState = world.method_8320(belowNeighborPos);
            class_2680 oppositeState = world.method_8320(oppositePos);
            if (neighborState.method_27852(class_2246.field_10164)) {
                return false;
            }
            boolean isNeighborBelowOpaque = belowNeighborState.method_26225();
            boolean isOppositeDirOpaque = oppositeState.method_26225();
            boolean isBelowNoSlab = !(belowNeighborState.method_26204() instanceof class_2482);
            boolean isOppositeDirNoSlab = !(oppositeState.method_26204() instanceof class_2482);
            boolean isNeighborBelowNoSnow = !belowNeighborState.method_27852(class_2246.field_10477) && !belowNeighborState.method_27852(ModBlocksRegistry.SNOW_ON_TOP);
            boolean bl = isOppositeDirNoSnow = !oppositeState.method_27852(class_2246.field_10477) && !oppositeState.method_27852(ModBlocksRegistry.SNOW_ON_TOP);
            if (isNeighborBelowOpaque && isOppositeDirOpaque && isBelowNoSlab && isOppositeDirNoSlab && isNeighborBelowNoSnow && isOppositeDirNoSnow) {
                bottomOfMountain = true;
            }
            if (!neighborState.method_26216((class_1922)world, neighborPos) || neighborState.method_26204() instanceof class_2482 || neighborState.method_27852(class_2246.field_10477) || world.method_8320(neighborPos.method_10084()).method_26225() && world.method_8320(neighborPos.method_10084()).method_26204() != class_2246.field_10477) continue;
            validNeighbors = true;
        }
        return validNeighbors && bottomOfMountain;
    }
}

