/*
 * Decompiled with CFR 0.152.
 */
package net.countered.terrainslabs;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.countered.datagen.ModBlockTagsProvider;
import net.countered.datagen.ModLootTableProvider;
import net.countered.datagen.ModModelProvider;
import net.countered.datagen.ModRecipeProvider;
import net.countered.datagen.ModWorldGenerator;
import net.countered.terrainslabs.worldgen.feature.ModConfiguredFeatures;
import net.countered.terrainslabs.worldgen.feature.ModPlacedFeatures;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_7877;
import net.minecraft.class_7924;

public class TerrainSlabsDataGenerator
implements DataGeneratorEntrypoint {
    public void buildRegistry(class_7877 registryBuilder) {
        registryBuilder.method_46777(class_7924.field_41239, ModConfiguredFeatures::bootstrap);
        registryBuilder.method_46777(class_7924.field_41245, ModPlacedFeatures::bootstrap);
    }

    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(ModWorldGenerator::new);
        pack.addProvider(ModModelProvider::new);
        pack.addProvider(ModLootTableProvider::new);
        pack.addProvider(ModBlockTagsProvider::new);
        pack.addProvider(ModRecipeProvider::new);
        Runtime.getRuntime().addShutdownHook(new Thread(this::deleteGeneratedDirectory));
    }

    private void deleteGeneratedDirectory() {
        Path generatedDir = Path.of("src", "main", "generated", "assets", "minecraft");
        if (Files.exists(generatedDir, new LinkOption[0])) {
            try {
                this.deleteDirectoryRecursively(generatedDir.toFile());
                System.out.println("Deleted generated directory after data generation: " + String.valueOf(generatedDir));
            }
            catch (IOException e) {
                System.err.println("Error deleting directory: " + e.getMessage());
            }
        }
    }

    private void deleteDirectoryRecursively(File dir) throws IOException {
        File[] allContents = dir.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                if (file.isDirectory()) {
                    this.deleteDirectoryRecursively(file);
                    continue;
                }
                file.delete();
            }
        }
        dir.delete();
    }
}

