/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.blay09.mods.cookingforblockheads.block.CounterBlock;
import net.blay09.mods.cookingforblockheads.block.entity.CounterBlockEntity;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CounterRenderer<T extends CounterBlockEntity>
implements BlockEntityRenderer<T> {
    private static final RandomSource random = RandomSource.create();
    private static final float doorOriginX = 0.84375f;
    private static final float doorOriginZ = 0.09375f;

    public CounterRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected float getDoorOriginX() {
        return 0.84375f;
    }

    protected float getDoorOriginZ() {
        return 0.09375f;
    }

    protected float getBottomShelfOffsetY() {
        return -0.85f;
    }

    protected float getTopShelfOffsetY() {
        return 0.35f;
    }

    protected BakedModel getDoorModel(@Nullable DyeColor blockColor, boolean isFlipped) {
        int colorIndex = blockColor != null ? blockColor.getId() + 1 : 0;
        return isFlipped ? (BakedModel)ModModels.counterDoorsFlipped.get(colorIndex).get() : (BakedModel)ModModels.counterDoors.get(colorIndex).get();
    }

    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        DyeColor dyeColor;
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        BlockState state = blockEntity.getBlockState();
        Block block = state.getBlock();
        if (block instanceof CounterBlock) {
            CounterBlock counterBlock = (CounterBlock)block;
            dyeColor = counterBlock.getColor();
        } else {
            dyeColor = null;
        }
        DyeColor blockColor = dyeColor;
        float blockAngle = ((CounterBlockEntity)blockEntity).getFacing().toYRot();
        float doorAngle = ((CounterBlockEntity)blockEntity).getDoorAnimator().getRenderAngle(partialTicks);
        boolean isFlipped = ((CounterBlockEntity)blockEntity).isFlipped();
        poseStack.pushPose();
        float doorOriginX = this.getDoorOriginX();
        float doorOriginZ = this.getDoorOriginZ();
        float doorDirection = -1.0f;
        if (isFlipped) {
            doorOriginX = 1.0f - doorOriginX;
            doorDirection = 1.0f;
        }
        RenderUtils.applyBlockAngle(poseStack, blockEntity.getBlockState());
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        poseStack.translate(doorOriginX, 0.0f, doorOriginZ);
        poseStack.mulPose(Axis.YP.rotationDegrees(doorDirection * (float)Math.toDegrees(doorAngle)));
        poseStack.translate(-doorOriginX, 0.0f, -doorOriginZ);
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        BakedModel model = this.getDoorModel(blockColor, isFlipped);
        dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, model, blockEntity.getBlockState(), blockEntity.getBlockPos(), poseStack, buffer.getBuffer(RenderType.solid()), false, random, 0L, 0);
        poseStack.popPose();
        if (doorAngle > 0.0f) {
            poseStack.pushPose();
            poseStack.translate(0.0, 0.5, 0.0);
            RenderUtils.applyBlockAngle(poseStack, blockEntity.getBlockState());
            poseStack.scale(0.3f, 0.3f, 0.3f);
            Container itemHandler = ((CounterBlockEntity)blockEntity).getContainer();
            int itemsPerShelf = itemHandler.getContainerSize() / 2;
            int itemsPerRow = itemsPerShelf / 2;
            for (int i = itemHandler.getContainerSize() - 1; i >= 0; --i) {
                ItemStack itemStack = itemHandler.getItem(i);
                if (itemStack.isEmpty()) continue;
                int shelfIndex = i % itemsPerShelf;
                int rowIndex = i % itemsPerRow;
                float spacing = 2.0f / (float)itemsPerRow;
                float offsetX = ((float)rowIndex - (float)itemsPerRow / 2.0f) * -spacing + (shelfIndex >= itemsPerRow ? -0.2f : 0.0f);
                float offsetY = i < itemsPerShelf ? this.getTopShelfOffsetY() : this.getBottomShelfOffsetY();
                float offsetZ = shelfIndex < itemsPerRow ? 0.5f : -0.5f;
                poseStack.pushPose();
                poseStack.translate(offsetX, offsetY, offsetZ);
                poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
                RenderUtils.renderItem(itemStack, combinedLight, poseStack, buffer, level);
                poseStack.popPose();
            }
            poseStack.popPose();
        }
    }
}

