/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.blay09.mods.cookingforblockheads.block.BaseKitchenBlock;
import net.blay09.mods.cookingforblockheads.block.CabinetBlock;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ConnectorBlock
extends BaseKitchenBlock {
    public static final MapCodec<ConnectorBlock> CODEC = ConnectorBlock.simpleCodec(ConnectorBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.STAIRS_SHAPE;

    protected ConnectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)Half.BOTTOM)).setValue(SHAPE, (Comparable)StairsShape.STRAIGHT));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (itemStack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (this.tryRecolorBlock(state, itemStack, level, pos, player, blockHitResult)) {
            return ItemInteractionResult.CONSUME_PARTIAL;
        }
        return ItemInteractionResult.FAIL;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction clickedFace = context.getClickedFace();
        BlockPos clickedPos = context.getClickedPos();
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue(HALF, (Comparable)(!(clickedFace == Direction.DOWN || clickedFace != Direction.UP && context.getClickLocation().y - (double)clickedPos.getY() > 0.5) ? Half.BOTTOM : Half.TOP));
        return (BlockState)state.setValue(SHAPE, (Comparable)ConnectorBlock.getStairsShape(state, (BlockGetter)context.getLevel(), clickedPos));
    }

    private static StairsShape getStairsShape(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        Direction frontFacing;
        Direction behindFacing;
        Direction facing = (Direction)state.getValue((Property)FACING);
        Half half = (Half)state.getValue(HALF);
        BlockState behind = blockGetter.getBlockState(pos.relative(facing));
        if (ConnectorBlock.isValidConnector(behind) && half == ConnectorBlock.getHalfFromNonStair(behind) && (behindFacing = ConnectorBlock.getFacingFromNonStair(behind)).getAxis() != facing.getAxis() && ConnectorBlock.canTakeShape(state, blockGetter, pos, behindFacing.getOpposite())) {
            if (behindFacing == facing.getCounterClockWise()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState front = blockGetter.getBlockState(pos.relative(facing.getOpposite()));
        if (ConnectorBlock.isValidConnector(front) && half == ConnectorBlock.getHalfFromNonStair(front) && (frontFacing = ConnectorBlock.getFacingFromNonStair(front)).getAxis() != facing.getAxis() && ConnectorBlock.canTakeShape(state, blockGetter, pos, frontFacing)) {
            if (frontFacing == facing.getCounterClockWise()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(BlockState state, BlockGetter blockGetter, BlockPos pos, Direction direction) {
        BlockState facingState = blockGetter.getBlockState(pos.relative(direction));
        return !ConnectorBlock.isValidConnector(facingState) || ConnectorBlock.getFacingFromNonStair(facingState) != state.getValue((Property)FACING) || ConnectorBlock.getHalfFromNonStair(facingState) != state.getValue(HALF);
    }

    private static boolean isValidConnector(BlockState state) {
        return state.getBlock() instanceof ConnectorBlock || state.getBlock() instanceof BaseKitchenBlock && state.hasProperty((Property)FACING);
    }

    private static Half getHalfFromNonStair(BlockState state) {
        if (state.hasProperty(HALF)) {
            return (Half)state.getValue(HALF);
        }
        if (state.getBlock() instanceof CabinetBlock) {
            return Half.TOP;
        }
        return Half.BOTTOM;
    }

    private static Direction getFacingFromNonStair(BlockState state) {
        if (!(state.getBlock() instanceof ConnectorBlock)) {
            return ((Direction)state.getValue((Property)FACING)).getOpposite();
        }
        return (Direction)state.getValue((Property)FACING);
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirror) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        StairsShape shape = (StairsShape)state.getValue(SHAPE);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (facing.getAxis() != Direction.Axis.Z) break;
                return switch (shape) {
                    case StairsShape.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    default -> state.rotate(Rotation.CLOCKWISE_180);
                };
            }
            case FRONT_BACK: {
                if (facing.getAxis() != Direction.Axis.X) break;
                return switch (shape) {
                    default -> throw new MatchException(null, null);
                    case StairsShape.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    case StairsShape.STRAIGHT -> state.rotate(Rotation.CLOCKWISE_180);
                };
            }
        }
        return super.mirror(state, mirror);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HALF, SHAPE});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return null;
    }

    @Override
    protected void appendHoverDescriptionText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.cookingforblockheads.connector.description").withStyle(ChatFormatting.GRAY));
    }

    @Override
    protected BlockState getDyedStateOf(BlockState state, @Nullable DyeColor color) {
        Block block = color == null ? ModBlocks.connector : ModBlocks.dyedConnectors[color.ordinal()];
        return (BlockState)((BlockState)((BlockState)block.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue(HALF, (Comparable)((Half)state.getValue(HALF)))).setValue(SHAPE, (Comparable)((StairsShape)state.getValue(SHAPE)));
    }
}

