/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.LivingDamageEvent;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.entity.CowJarBlockEntity;
import net.blay09.mods.cookingforblockheads.network.message.SyncedEffectMessage;
import net.blay09.mods.cookingforblockheads.tag.ModEntityTypeTags;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CowJarHandler {
    public static void onLivingDamage(LivingDamageEvent event) {
        if (!CookingForBlockheadsConfig.getActive().cowJarEnabled) {
            return;
        }
        if (event.getDamageSource().getMsgId().equals("anvil") && event.getEntity().getType().is(ModEntityTypeTags.COW)) {
            LivingEntity entity = event.getEntity();
            BlockPos pos = entity.blockPosition();
            Level level = entity.level();
            BlockState blockBelow = level.getBlockState(pos);
            if (blockBelow.getBlock() == ModBlocks.milkJar) {
                boolean wasCompressed;
                level.setBlockAndUpdate(pos, ModBlocks.cowJar.defaultBlockState());
                BlockEntity tileEntity = level.getBlockEntity(pos);
                if (tileEntity instanceof CowJarBlockEntity && entity.getCustomName() != null) {
                    MutableComponent textComponent = Component.translatable((String)"container.cookingforblockheads.cow_jar_custom", (Object[])new Object[]{entity.getCustomName()});
                    ((CowJarBlockEntity)tileEntity).setCustomName((Component)textComponent);
                }
                if ((wasCompressed = Balm.getHooks().getPersistentData((Entity)event.getEntity()).getCompound("excompressum").getBoolean("Compressed")) && tileEntity instanceof CowJarBlockEntity) {
                    ((CowJarBlockEntity)tileEntity).setCompressedCow(true);
                }
            }
            Balm.getNetworking().sendToTracking((Entity)entity, (CustomPacketPayload)new SyncedEffectMessage(pos, SyncedEffectMessage.Type.COW_IN_A_JAR));
            entity.remove(Entity.RemovalReason.DISCARDED);
            event.setCanceled(true);
        }
    }
}

