/*
 * Decompiled with CFR 0.152.
 */
package reloc.org.sat4j.tools.encoding;

import java.util.ArrayList;
import java.util.HashMap;
import reloc.org.sat4j.core.ConstrGroup;
import reloc.org.sat4j.core.VecInt;
import reloc.org.sat4j.specs.ContradictionException;
import reloc.org.sat4j.specs.IConstr;
import reloc.org.sat4j.specs.ISolver;
import reloc.org.sat4j.specs.IVecInt;
import reloc.org.sat4j.tools.encoding.Binomial;
import reloc.org.sat4j.tools.encoding.EncodingStrategyAdapter;

public class Product
extends EncodingStrategyAdapter {
    private static final long serialVersionUID = 1L;

    public IConstr addAtMostNonOpt(ISolver solver, IVecInt literals, int k) throws ContradictionException {
        int i;
        int d;
        int i2;
        ConstrGroup group = new ConstrGroup(false);
        VecInt clause = new VecInt();
        int n = literals.size();
        if (k > n) {
            return group;
        }
        if (n == k + 1) {
            for (int i3 = 0; i3 < n; ++i3) {
                clause.push(-literals.get(i3));
            }
            group.add(solver.addClause(clause));
            clause.clear();
            return group;
        }
        if (n < 7) {
            Binomial binomial = new Binomial();
            return binomial.addAtMost(solver, literals, k);
        }
        int p = (int)Math.ceil(Math.pow(n, 1.0 / (double)(k + 1)));
        int[][] a = new int[n][k + 1];
        int[] result = this.decompositionBase10VersBaseP(0, p, k + 1);
        a[0] = result;
        ArrayList<Integer> dejaPris = new ArrayList<Integer>();
        dejaPris.add(0);
        int tmp = 1;
        for (i2 = 1; i2 <= k + 1; ++i2) {
            a[i2] = this.decompositionBase10VersBaseP(tmp, p, k + 1);
            dejaPris.add(tmp);
            tmp *= p;
        }
        tmp = 2;
        for (i2 = k + 2; i2 < n; ++i2) {
            while (dejaPris.contains(tmp)) {
                ++tmp;
            }
            a[i2] = this.decompositionBase10VersBaseP(tmp, p, k + 1);
            ++tmp;
        }
        ArrayList[] hashTupleSetTable = new ArrayList[k + 1];
        int[][][] aWithoutD = new int[n][k + 1][k];
        HashMap[] ady = new HashMap[k + 1];
        VecInt[] adxd = new VecInt[k + 1];
        for (d = 0; d < k + 1; ++d) {
            hashTupleSetTable[d] = new ArrayList();
            ady[d] = new HashMap();
            adxd[d] = new VecInt();
            for (i = 0; i < n; ++i) {
                for (int j = 0; j < k; ++j) {
                    aWithoutD[i][d][j] = j < d ? a[i][j] : a[i][j + 1];
                }
                int hash = this.recompositionBase10DepuisBaseP(aWithoutD[i][d], p);
                if (hashTupleSetTable[d].contains(hash)) continue;
                hashTupleSetTable[d].add(hash);
                int varId = solver.nextFreeVarId(true);
                ady[d].put(hash, varId);
                adxd[d].push(varId);
            }
        }
        for (d = 0; d < k + 1; ++d) {
            for (i = 0; i < n; ++i) {
                clause.push(-literals.get(i));
                clause.push((Integer)ady[d].get(this.recompositionBase10DepuisBaseP(aWithoutD[i][d], p)));
                group.add(solver.addClause(clause));
                clause.clear();
            }
            group.add(this.addAtMost(solver, adxd[d], k));
        }
        return group;
    }

    @Override
    public IConstr addAtMostOne(ISolver solver, IVecInt literals) throws ContradictionException {
        int i;
        ConstrGroup group = new ConstrGroup(false);
        VecInt clause = new VecInt();
        int n = literals.size();
        if (n < 7) {
            Binomial binomial = new Binomial();
            return binomial.addAtMostOne(solver, literals);
        }
        int p = (int)Math.ceil(Math.sqrt(n));
        int q = (int)Math.ceil((double)n / (double)p);
        int[] u = new int[p];
        int[] v = new int[q];
        for (i = 0; i < p; ++i) {
            u[i] = solver.nextFreeVarId(true);
        }
        for (i = 0; i < q; ++i) {
            v[i] = solver.nextFreeVarId(true);
        }
        int cpt = 0;
        for (int i2 = 0; i2 < p; ++i2) {
            for (int j = 0; j < q; ++j) {
                if (cpt >= n) continue;
                clause.push(-literals.get(cpt));
                clause.push(u[i2]);
                group.add(solver.addClause(clause));
                clause.clear();
                clause.push(-literals.get(cpt));
                clause.push(v[j]);
                group.add(solver.addClause(clause));
                clause.clear();
                ++cpt;
            }
        }
        group.add(this.addAtMostOne(solver, new VecInt(u)));
        group.add(this.addAtMostOne(solver, new VecInt(v)));
        return group;
    }

    private int[] decompositionBase10VersBaseP(int n, int p, int nbBits) {
        int[] result = new int[nbBits];
        int reste = n;
        for (int j = 0; j < nbBits - 1; ++j) {
            int pow = (int)Math.pow(p, nbBits - j - 1);
            int quotient = reste / pow;
            result[j] = quotient + 1;
            reste -= quotient * pow;
        }
        result[nbBits - 1] = reste + 1;
        return result;
    }

    private int recompositionBase10DepuisBaseP(int[] tab, int p) {
        int result = 0;
        for (int i = 0; i < tab.length - 1; ++i) {
            result = (result + tab[i] - 1) * p;
        }
        return result += tab[tab.length - 1] - 1;
    }

    @Override
    public IConstr addExactlyOne(ISolver solver, IVecInt literals) throws ContradictionException {
        ConstrGroup group = new ConstrGroup(false);
        group.add(this.addAtLeastOne(solver, literals));
        group.add(this.addAtMostOne(solver, literals));
        return group;
    }

    @Override
    public IConstr addExactly(ISolver solver, IVecInt literals, int degree) throws ContradictionException {
        ConstrGroup group = new ConstrGroup(false);
        group.add(this.addAtLeast(solver, literals, degree));
        group.add(this.addAtMost(solver, literals, degree));
        return group;
    }
}

