/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer.patch;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.objectweb.asm.tree.analysis.SourceValue;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.connector.transformer.jar.IntermediateMapping;
import org.sinytra.connector.transformer.patch.ClassNodeTransformer;
import reloc.net.minecraftforge.srgutils.IMappingFile;

public class ReflectionRenamingTransformer
implements ClassNodeTransformer.ClassProcessor {
    private final IMappingFile mappingFile;
    private final IntermediateMapping flatMappings;

    public ReflectionRenamingTransformer(IMappingFile mappingFile, IntermediateMapping flatMappings) {
        this.mappingFile = mappingFile;
        this.flatMappings = flatMappings;
    }

    @Override
    public Patch.Result process(ClassNode node) {
        boolean applied = false;
        for (MethodNode method : node.methods) {
            ReflectionRemapperInterpreter interpreter = new ReflectionRemapperInterpreter(589824, this.mappingFile, this.flatMappings);
            MethodCallAnalyzer.analyzeInterpretMethod(method, interpreter);
            applied |= interpreter.remapApplied();
        }
        return applied ? Patch.Result.APPLY : Patch.Result.PASS;
    }

    private static class ReflectionRemapperInterpreter
    extends SourceInterpreter {
        private static final Type STR_TYPE = Type.getType(String.class);
        private final Collection<MethodInsnNode> seen = new HashSet<MethodInsnNode>();
        private final IMappingFile mappings;
        private final IntermediateMapping fastMappings;
        private boolean remapApplied = false;

        public ReflectionRemapperInterpreter(int api, IMappingFile mappings, IntermediateMapping fastMappings) {
            super(api);
            this.mappings = mappings;
            this.fastMappings = fastMappings;
        }

        public boolean remapApplied() {
            return this.remapApplied;
        }

        public SourceValue naryOperation(AbstractInsnNode insn, List<? extends SourceValue> values) {
            MethodInsnNode methodInsn;
            if (insn instanceof MethodInsnNode && !this.seen.contains(methodInsn = (MethodInsnNode)insn)) {
                this.seen.add(methodInsn);
                Type[] args = Type.getArgumentTypes((String)methodInsn.desc);
                if (args.length >= 3 && STR_TYPE.equals((Object)args[0]) && STR_TYPE.equals((Object)args[1]) && STR_TYPE.equals((Object)args[2]) && values.size() >= 3) {
                    String owner;
                    IMappingFile.IClass cls;
                    LdcInsnNode ownerInsn = ReflectionRemapperInterpreter.getSingleLDCString(values.get(0));
                    LdcInsnNode nameInsn = ReflectionRemapperInterpreter.getSingleLDCString(values.get(1));
                    LdcInsnNode descInsn = ReflectionRemapperInterpreter.getSingleLDCString(values.get(2));
                    if (ownerInsn != null && nameInsn != null && descInsn != null && (cls = this.mappings.getClass((owner = (String)ownerInsn.cst).replace('.', '/'))) != null) {
                        String name = (String)nameInsn.cst;
                        String desc = (String)descInsn.cst;
                        IMappingFile.IMethod mtd = cls.getMethod(name, desc);
                        if (mtd != null) {
                            ownerInsn.cst = owner.contains(".") ? cls.getMapped().replace('/', '.') : cls.getMapped();
                            nameInsn.cst = mtd.getMapped();
                            descInsn.cst = mtd.getMappedDescriptor();
                            this.remapApplied = true;
                        } else {
                            String mappedName = this.fastMappings.mapMethod(name, desc);
                            if (mappedName != null) {
                                ownerInsn.cst = owner.contains(".") ? cls.getMapped().replace('/', '.') : cls.getMapped();
                                nameInsn.cst = mappedName;
                                descInsn.cst = this.mappings.remapDescriptor(desc);
                                this.remapApplied = true;
                            }
                        }
                    }
                }
            }
            return super.naryOperation(insn, values);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        private static LdcInsnNode getSingleLDCString(SourceValue value) {
            if (value.insns.size() != 1) return null;
            Object e = value.insns.iterator().next();
            if (!(e instanceof LdcInsnNode)) return null;
            LdcInsnNode ldc = (LdcInsnNode)e;
            if (!(ldc.cst instanceof String)) return null;
            LdcInsnNode ldcInsnNode = ldc;
            return ldcInsnNode;
        }
    }
}

