/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.locator.filter;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.jarhandling.impl.Jar;
import cpw.mods.jarhandling.impl.JarContentsImpl;
import cpw.mods.modlauncher.api.LambdaExceptionUtils;
import cpw.mods.niofs.union.UnionFileSystem;
import cpw.mods.niofs.union.UnionPathFilter;
import java.lang.invoke.VarHandle;
import java.nio.file.FileSystem;
import java.util.Set;
import net.neoforged.neoforgespi.locating.IModFile;
import org.sinytra.connector.locator.filter.PackageTracker;
import org.sinytra.connector.util.ConnectorUtil;
import org.slf4j.Logger;

public final class ForgeModPackageFilter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final VarHandle JAR_CONTENTS = (VarHandle)LambdaExceptionUtils.uncheck(() -> ConnectorUtil.TRUSTED_LOOKUP.findVarHandle(Jar.class, "contents", JarContentsImpl.class));
    private static final VarHandle JAR_CONTENTS_PACKAGES = (VarHandle)LambdaExceptionUtils.uncheck(() -> ConnectorUtil.TRUSTED_LOOKUP.findVarHandle(JarContentsImpl.class, "packages", Set.class));
    private static final VarHandle UPFS_FILTER = (VarHandle)LambdaExceptionUtils.uncheck(() -> ConnectorUtil.TRUSTED_LOOKUP.findVarHandle(UnionFileSystem.class, "pathFilter", UnionPathFilter.class));

    public static void filterPackages(Iterable<IModFile> fmlMods) {
        Set<String> existingPackages = ForgeModPackageFilter.class.getModule().getPackages();
        for (IModFile modFile : fmlMods) {
            ForgeModPackageFilter.filterModFile(modFile, existingPackages);
        }
    }

    private static void filterModFile(IModFile modFile, Set<String> existingPackages) {
        SecureJar jar = modFile.getSecureJar();
        Set<String> packages = jar.moduleDataProvider().descriptor().packages();
        Sets.SetView common = Sets.intersection(packages, existingPackages);
        if (!common.isEmpty() && jar instanceof Jar) {
            Jar jarImpl = (Jar)jar;
            LOGGER.debug("Filtering {} packages from mod file {}", (Object)common.size(), (Object)jar.getPrimaryPath().getFileName());
            PackageTracker filter = new PackageTracker((Set<String>)common);
            FileSystem jarFS = jarImpl.getRootPath().getFileSystem();
            if (jarFS instanceof UnionFileSystem) {
                UnionFileSystem ufs = (UnionFileSystem)jarFS;
                ForgeModPackageFilter.injectUFSFilter(ufs, filter);
                ForgeModPackageFilter.forceRecomputeJarPackages(jarImpl);
            }
        }
    }

    private static void injectUFSFilter(UnionFileSystem ufs, UnionPathFilter filter) {
        UnionPathFilter existing = ufs.getFilesystemFilter();
        UnionPathFilter merged = existing != null ? (a, b) -> existing.test(a, b) && filter.test(a, b) : filter;
        UPFS_FILTER.set(ufs, merged);
    }

    private static void forceRecomputeJarPackages(Jar jar) {
        JarContentsImpl jarContents = (JarContentsImpl)LambdaExceptionUtils.uncheck(() -> JAR_CONTENTS.get(jar));
        LambdaExceptionUtils.uncheck(() -> JAR_CONTENTS_PACKAGES.set(jarContents, null));
    }
}

