/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.operation.param;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.analysis.locals.LVTSnapshot;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.transformer.operation.param.ParamTransformationUtil;
import org.sinytra.adapter.patch.transformer.operation.param.ParameterTransformer;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.slf4j.Logger;

public record SubstituteParameterTransformer(int target, int substitute) implements ParameterTransformer
{
    static final Codec<SubstituteParameterTransformer> CODEC = RecordCodecBuilder.create(in -> in.group((App)Codec.intRange((int)0, (int)255).fieldOf("target").forGetter(SubstituteParameterTransformer::target), (App)Codec.intRange((int)0, (int)255).fieldOf("substitute").forGetter(SubstituteParameterTransformer::substitute)).apply((Applicative)in, SubstituteParameterTransformer::new));
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context, List<Type> parameters, int offset) {
        int paramIndex = this.target + offset;
        int substituteParamIndex = this.substitute + offset;
        boolean isNonStatic = !methodContext.isStatic();
        int localIndex = ParamTransformationUtil.calculateLVTIndex(parameters, isNonStatic, paramIndex);
        if (methodNode.parameters.size() <= paramIndex) {
            return Patch.Result.PASS;
        }
        LVTSnapshot.with(methodNode, () -> {
            LOGGER.info("Substituting parameter {} for {} in {}.{}", new Object[]{paramIndex, substituteParamIndex, classNode.name, methodNode.name});
            parameters.remove(paramIndex);
            methodNode.parameters.remove(paramIndex);
            methodNode.localVariables.removeIf(lvn -> lvn.index == localIndex);
            int substituteIndex = ParamTransformationUtil.calculateLVTIndex(parameters, isNonStatic, substituteParamIndex);
            AdapterUtil.replaceLVT(methodNode, idx -> idx == localIndex ? substituteIndex : idx);
        });
        return Patch.Result.COMPUTE_FRAMES;
    }

    @Override
    public Codec<? extends ParameterTransformer> codec() {
        return CODEC;
    }
}

