/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.operation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableAnnotationNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ParameterNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.analysis.locals.LVTSnapshot;
import org.sinytra.adapter.patch.analysis.locals.LocalVariableLookup;
import org.sinytra.adapter.patch.analysis.params.SimpleParamsDiffSnapshot;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.fixes.BytecodeFixerUpper;
import org.sinytra.adapter.patch.fixes.ModifyArgsOffsetTransformer;
import org.sinytra.adapter.patch.fixes.TypeAdapter;
import org.sinytra.adapter.patch.transformer.operation.param.InjectParameterTransform;
import org.sinytra.adapter.patch.transformer.operation.param.ParamTransformTarget;
import org.sinytra.adapter.patch.transformer.operation.param.ParamTransformationUtil;
import org.sinytra.adapter.patch.transformer.operation.param.SwapParametersTransformer;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.SingleValueHandle;

@Deprecated
public record ModifyMethodParams(SimpleParamsDiffSnapshot context, ParamTransformTarget targetType, boolean ignoreOffset, @Nullable LVTFixer lvtFixer) implements MethodTransform
{
    public static final Codec<ModifyMethodParams> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SimpleParamsDiffSnapshot.CODEC.fieldOf("context").forGetter(ModifyMethodParams::context), (App)ParamTransformTarget.CODEC.optionalFieldOf("targetInjectionPoint", (Object)ParamTransformTarget.ALL).forGetter(ModifyMethodParams::targetType)).apply((Applicative)instance, (context, targetInjectionPoint) -> new ModifyMethodParams((SimpleParamsDiffSnapshot)context, (ParamTransformTarget)((Object)((Object)targetInjectionPoint)), false, null)));

    public ModifyMethodParams(SimpleParamsDiffSnapshot context, ParamTransformTarget targetType, boolean ignoreOffset, @Nullable LVTFixer lvtFixer) {
        if (context.isEmpty()) {
            throw new IllegalArgumentException("Method parameter transformation contains no changes");
        }
    }

    public static ModifyMethodParams create(SimpleParamsDiffSnapshot diff, ParamTransformTarget targetType) {
        return new ModifyMethodParams(diff, targetType, false, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Codec<? extends MethodTransform> codec() {
        return CODEC;
    }

    @Override
    public Collection<String> getAcceptedAnnotations() {
        Set<String> targets = this.targetType.getTargetMixinTypes();
        return targets.isEmpty() ? PatchInstance.KNOWN_MIXIN_TYPES : targets;
    }

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        int offset;
        boolean needsOffset;
        AnnotationHandle annotation = methodContext.methodAnnotation();
        Type[] params = Type.getArgumentTypes((String)methodNode.desc);
        ArrayList<Type> newParameterTypes = new ArrayList<Type>(Arrays.asList(params));
        boolean isNonStatic = (methodNode.access & 8) == 0;
        boolean bl = needsOffset = annotation.matchesDesc("Lorg/spongepowered/asm/mixin/injection/Redirect;") && !this.ignoreOffset;
        int n = isNonStatic ? (needsOffset ? 2 : 1) : (offset = 0);
        if (annotation.matchesDesc("Lorg/spongepowered/asm/mixin/injection/ModifyVariable;")) {
            annotation.getValue("index").ifPresent(indexHandle -> this.context.insertions().forEach(pair -> {
                int localIndex = offset + (Integer)pair.getFirst();
                int indexValue = (Integer)indexHandle.get();
                if (indexValue >= localIndex) {
                    indexHandle.set(indexValue + 1);
                }
            }));
            return Patch.Result.APPLY;
        }
        if (annotation.matchesDesc("Lorg/spongepowered/asm/mixin/injection/ModifyArgs;")) {
            ModifyArgsOffsetTransformer.modify(methodNode, this.context.insertions());
            return Patch.Result.APPLY;
        }
        ArrayList<Pair<Integer, Integer>> offsetSwaps = new ArrayList<Pair<Integer, Integer>>(this.context.swaps());
        ArrayList<Pair<Integer, Integer>> offsetMoves = new ArrayList<Pair<Integer, Integer>>(this.context.moves());
        LocalVariableNode self = methodNode.localVariables.stream().filter(lvn -> lvn.index == 0).findFirst().orElseThrow();
        ArrayDeque<Pair<Integer, Type>> insertionQueue = new ArrayDeque<Pair<Integer, Type>>(this.context.insertions());
        while (!insertionQueue.isEmpty()) {
            Pair pair2 = (Pair)insertionQueue.pop();
            int index = (Integer)pair2.getFirst();
            Type type = (Type)pair2.getSecond();
            if (index > newParameterTypes.size() + 1) continue;
            LVTSnapshot lVTSnapshot = LVTSnapshot.take(methodNode);
            int lvtIndex = ParamTransformationUtil.calculateLVTIndex(newParameterTypes, isNonStatic, (needsOffset ? 1 : 0) + index);
            int paramOrdinal = isNonStatic && needsOffset ? index + 1 : index;
            ParameterNode newParameter = new ParameterNode("adapter_injected_" + paramOrdinal, 4096);
            newParameterTypes.add(paramOrdinal, type);
            methodNode.parameters.add(paramOrdinal, newParameter);
            InjectParameterTransform.offsetParameters(methodNode, paramOrdinal);
            offsetSwaps.replaceAll(integerIntegerPair -> integerIntegerPair.mapFirst(j -> j >= paramOrdinal ? j + 1 : j));
            offsetMoves.replaceAll(integerIntegerPair -> integerIntegerPair.mapFirst(j -> j >= paramOrdinal ? j + 1 : j).mapSecond(j -> j >= paramOrdinal ? j + 1 : j));
            methodNode.localVariables.add(paramOrdinal + (isNonStatic ? 1 : 0), new LocalVariableNode(newParameter.name, type.getDescriptor(), null, self.start, self.end, lvtIndex));
            lVTSnapshot.applyDifference(methodNode);
        }
        LocalVariableLookup lvtLookup = new LocalVariableLookup(methodNode);
        BytecodeFixerUpper bfu = context.environment().bytecodeFixerUpper();
        this.context.replacements().forEach(pair -> {
            int index = (Integer)pair.getFirst();
            Type type = (Type)pair.getSecond();
            newParameterTypes.set(index, type);
            int lvtOrdinal = offset + index;
            LocalVariableNode localVar = lvtLookup.getByOrdinal(lvtOrdinal);
            int localIndex = localVar.index;
            Type originalType = Type.getType((String)localVar.desc);
            localVar.desc = type.getDescriptor();
            localVar.signature = null;
            List<AbstractInsnNode> ignoreInsns = ParamTransformationUtil.findWrapOperationOriginalCall(methodNode, methodContext);
            if (type.getSort() == 10 && originalType.getSort() == 10) {
                for (AbstractInsnNode insn : methodNode.instructions) {
                    if (ignoreInsns.contains(insn)) continue;
                    if (insn instanceof MethodInsnNode) {
                        AbstractInsnNode previous;
                        MethodInsnNode minsn = (MethodInsnNode)insn;
                        if (minsn.owner.equals(originalType.getInternalName()) && (previous = minsn.getPrevious()) != null) {
                            while (!(previous instanceof LabelNode) && !(previous instanceof LineNumberNode)) {
                                if (previous instanceof VarInsnNode) {
                                    VarInsnNode varinsn = (VarInsnNode)previous;
                                    if (varinsn.var == localIndex) {
                                        minsn.owner = type.getInternalName();
                                        break;
                                    }
                                }
                                if ((previous = previous.getPrevious()) != null) continue;
                            }
                        }
                    }
                    if (!(insn instanceof VarInsnNode)) continue;
                    VarInsnNode varInsn = (VarInsnNode)insn;
                    if (varInsn.var != localIndex) continue;
                    int nextOp = insn.getNext().getOpcode();
                    if (bfu != null && nextOp != 198 && nextOp != 199) {
                        TypeAdapter typeFix = bfu.getTypeAdapter(type, originalType);
                        if (typeFix == null && annotation.matchesDesc("Lcom/llamalad7/mixinextras/injector/wrapoperation/WrapOperation;") && (typeFix = bfu.getTypeAdapter(params[0], originalType)) != null) {
                            varInsn.var = lvtLookup.getByParameterOrdinal((int)0).index;
                        }
                        if (typeFix != null) {
                            typeFix.apply(methodNode.instructions, (AbstractInsnNode)varInsn);
                        }
                    }
                    if (this.lvtFixer == null) continue;
                    this.lvtFixer.accept(varInsn.var, (AbstractInsnNode)varInsn, methodNode.instructions);
                }
            }
        });
        this.context.substitutes().forEach(pair -> {
            int paramIndex = (Integer)pair.getFirst();
            int substituteParamIndex = (Integer)pair.getSecond();
            if (methodNode.parameters.size() > paramIndex) {
                int localIndex = ParamTransformationUtil.calculateLVTIndex(newParameterTypes, isNonStatic, paramIndex);
                LVTSnapshot lvtSnapshot = LVTSnapshot.take(methodNode);
                methodContext.recordAudit(this, "Substitute parameter %s for %s", paramIndex, substituteParamIndex);
                methodNode.parameters.remove(paramIndex);
                newParameterTypes.remove(paramIndex);
                int substituteIndex = ParamTransformationUtil.calculateLVTIndex(newParameterTypes, isNonStatic, substituteParamIndex);
                methodNode.localVariables.removeIf(lvn -> lvn.index == localIndex);
                for (AbstractInsnNode insn : methodNode.instructions) {
                    SingleValueHandle<Integer> handle = AdapterUtil.handleLocalVarInsnValue(insn);
                    if (handle == null || handle.get() != localIndex) continue;
                    handle.set(substituteIndex);
                }
                lvtSnapshot.applyDifference(methodNode);
            }
        });
        for (Pair pair2 : offsetSwaps) {
            int from = (Integer)pair2.getFirst();
            int to = (Integer)pair2.getSecond();
            ParameterNode fromNode = (ParameterNode)methodNode.parameters.get(from);
            ParameterNode toNode = (ParameterNode)methodNode.parameters.get(to);
            int fromOldLVT = ParamTransformationUtil.calculateLVTIndex(newParameterTypes, isNonStatic, from);
            int toOldLVT = ParamTransformationUtil.calculateLVTIndex(newParameterTypes, isNonStatic, to);
            methodNode.parameters.set(from, toNode);
            methodNode.parameters.set(to, fromNode);
            Type fromType = (Type)newParameterTypes.get(from);
            Type toType = (Type)newParameterTypes.get(to);
            newParameterTypes.set(from, toType);
            newParameterTypes.set(to, fromType);
            methodContext.recordAudit(this, "Swap parameters %s <%s> and %s <%s>", from, fromNode.name, to, toNode.name);
            int fromNewLVT = ParamTransformationUtil.calculateLVTIndex(newParameterTypes, isNonStatic, from);
            int toNewLVT = ParamTransformationUtil.calculateLVTIndex(newParameterTypes, isNonStatic, to);
            SwapParametersTransformer.swapLVT(methodNode, fromOldLVT, toNewLVT).andThen(SwapParametersTransformer.swapLVT(methodNode, toOldLVT, fromNewLVT)).accept(null);
        }
        if (!this.context.removals().isEmpty()) {
            methodContext.recordAudit(this, "Remove parameters %s", this.context.removals());
        }
        this.context.removals().stream().sorted(Comparator.comparingInt(i -> i).reversed()).forEach(removal -> ModifyMethodParams.removeLocalVariable(methodNode, removal, offset, -1, newParameterTypes));
        offsetMoves.forEach(move -> {
            LocalVariableNode lvn;
            int from = (Integer)move.getFirst();
            int to = (Integer)move.getSecond();
            methodContext.recordAudit(this, "Move parameter from index {} to {}", from, to);
            int tempIndex = -999;
            Pair<@Nullable ParameterNode, @Nullable LocalVariableNode> removed = ModifyMethodParams.removeLocalVariable(methodNode, from, offset, tempIndex, newParameterTypes);
            if (removed.getFirst() != null) {
                methodNode.parameters.add(to, (ParameterNode)removed.getFirst());
            }
            if ((lvn = (LocalVariableNode)removed.getSecond()) != null) {
                Type type = Type.getType((String)lvn.desc);
                int varOffset = AdapterUtil.getLVTOffsetForType(type);
                if (to > from) {
                    to -= varOffset;
                }
                lvn.index = to + offset;
                ModifyMethodParams.offsetLVT(methodNode, lvn.index, varOffset);
                methodNode.localVariables.add(lvn.index, lvn);
                for (AbstractInsnNode insn : methodNode.instructions) {
                    SingleValueHandle<Integer> handle = AdapterUtil.handleLocalVarInsnValue(insn);
                    if (handle == null || handle.get() != tempIndex) continue;
                    handle.set(lvn.index);
                }
                newParameterTypes.add(to, type);
            }
        });
        this.context.inlines().stream().sorted(Comparator.comparingInt(Pair::getFirst).reversed()).forEach(inline -> {
            int index = (Integer)inline.getFirst();
            methodContext.recordAudit(this, "Inlining parameter {}", index);
            int replaceIndex = -999 + index;
            ModifyMethodParams.removeLocalVariable(methodNode, index, offset, replaceIndex, newParameterTypes);
            for (AbstractInsnNode insn : methodNode.instructions) {
                if (!(insn instanceof VarInsnNode)) continue;
                VarInsnNode varInsn = (VarInsnNode)insn;
                if (varInsn.var != replaceIndex) continue;
                InsnList replacementInsns = AdapterUtil.insnsWithAdapter((Consumer)inline.getSecond());
                methodNode.instructions.insert((AbstractInsnNode)varInsn, replacementInsns);
                methodNode.instructions.remove((AbstractInsnNode)varInsn);
            }
        });
        methodContext.updateDescription(this, newParameterTypes);
        return this.context.shouldComputeFrames() ? Patch.Result.COMPUTE_FRAMES : Patch.Result.APPLY;
    }

    private static Pair<@Nullable ParameterNode, @Nullable LocalVariableNode> removeLocalVariable(MethodNode methodNode, int paramIndex, int lvtOffset, int replaceIndex, List<Type> newParameterTypes) {
        LVTSnapshot snapshot = LVTSnapshot.take(methodNode);
        ParameterNode parameter = paramIndex < methodNode.parameters.size() ? (ParameterNode)methodNode.parameters.remove(paramIndex) : null;
        methodNode.localVariables.sort(Comparator.comparingInt(lvn -> lvn.index));
        LocalVariableNode lvn2 = (LocalVariableNode)methodNode.localVariables.remove(paramIndex + lvtOffset);
        if (lvn2 != null) {
            for (AbstractInsnNode insn : methodNode.instructions) {
                SingleValueHandle<Integer> handle = AdapterUtil.handleLocalVarInsnValue(insn);
                if (handle == null || handle.get() != lvn2.index) continue;
                handle.set(replaceIndex);
            }
        }
        newParameterTypes.remove(paramIndex);
        snapshot.applyDifference(methodNode);
        return Pair.of((Object)parameter, (Object)lvn2);
    }

    private static void offsetLVT(MethodNode methodNode, int lvtIndex, int offset) {
        for (LocalVariableNode localVariable : methodNode.localVariables) {
            if (localVariable.index < lvtIndex) continue;
            localVariable.index += offset;
        }
        for (AbstractInsnNode insn : methodNode.instructions) {
            SingleValueHandle<Integer> handle = AdapterUtil.handleLocalVarInsnValue(insn);
            if (handle == null || handle.get() < lvtIndex) continue;
            handle.set(handle.get() + offset);
        }
        if (methodNode.visibleLocalVariableAnnotations != null) {
            for (LocalVariableAnnotationNode localVariableAnnotation : methodNode.visibleLocalVariableAnnotations) {
                List annotationIndices = localVariableAnnotation.index;
                for (int j = 0; j < annotationIndices.size(); ++j) {
                    Integer annoIndex = (Integer)annotationIndices.get(j);
                    if (annoIndex < lvtIndex) continue;
                    annotationIndices.set(j, annoIndex + 1);
                }
            }
        }
    }

    public static interface LVTFixer {
        public void accept(int var1, AbstractInsnNode var2, InsnList var3);
    }

    public static class Builder {
        private final List<Pair<Integer, Type>> insertions = new ArrayList<Pair<Integer, Type>>();
        private final List<Pair<Integer, Type>> replacements = new ArrayList<Pair<Integer, Type>>();
        private final List<Pair<Integer, Integer>> substitutes = new ArrayList<Pair<Integer, Integer>>();
        private final List<Integer> removals = new ArrayList<Integer>();
        private final List<Pair<Integer, Integer>> swap = new ArrayList<Pair<Integer, Integer>>();
        private final List<Pair<Integer, Consumer<InstructionAdapter>>> inlines = new ArrayList<Pair<Integer, Consumer<InstructionAdapter>>>();
        private ParamTransformTarget targetType = ParamTransformTarget.ALL;
        private boolean ignoreOffset = false;
        @Nullable
        private LVTFixer lvtFixer;

        public Builder insert(int index, Type type) {
            this.insertions.add((Pair<Integer, Type>)Pair.of((Object)index, (Object)type));
            return this;
        }

        public Builder inline(int index, Consumer<InstructionAdapter> inliner) {
            this.inlines.add((Pair<Integer, Consumer<InstructionAdapter>>)Pair.of((Object)index, inliner));
            return this;
        }

        public Builder replacements(List<Pair<Integer, Type>> replacements) {
            this.replacements.addAll(replacements);
            return this;
        }

        public Builder replace(int index, Type type) {
            this.replacements.add((Pair<Integer, Type>)Pair.of((Object)index, (Object)type));
            return this;
        }

        public Builder substitute(int index, int substitute) {
            this.substitutes.add((Pair<Integer, Integer>)Pair.of((Object)index, (Object)substitute));
            return this;
        }

        public Builder remove(int index) {
            this.removals.add(index);
            return this;
        }

        public Builder remove(Collection<Integer> indices) {
            this.removals.addAll(indices);
            return this;
        }

        public Builder swap(int original, int replacement) {
            this.swap.add((Pair<Integer, Integer>)Pair.of((Object)original, (Object)replacement));
            return this;
        }

        public Builder targetType(ParamTransformTarget targetType) {
            this.targetType = targetType;
            return this;
        }

        public Builder ignoreOffset() {
            this.ignoreOffset = true;
            return this;
        }

        public Builder lvtFixer(LVTFixer lvtFixer) {
            this.lvtFixer = lvtFixer;
            return this;
        }

        public Builder chain(Consumer<Builder> consumer) {
            consumer.accept(this);
            return this;
        }

        public ModifyMethodParams build() {
            SimpleParamsDiffSnapshot context = new SimpleParamsDiffSnapshot(this.insertions, this.replacements, this.swap, this.substitutes, this.removals, List.of(), this.inlines);
            return new ModifyMethodParams(context, this.targetType, this.ignoreOffset, this.lvtFixer);
        }
    }
}

