/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.fixes;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.analysis.locals.LocalVarAnalyzer;
import org.sinytra.adapter.patch.analysis.params.EnhancedParamsDiff;
import org.sinytra.adapter.patch.analysis.params.LayeredParamsDiffSnapshot;
import org.sinytra.adapter.patch.analysis.params.SimpleParamsDiffSnapshot;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.analysis.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.fixes.ModifyArgsOffsetTransformer;
import org.sinytra.adapter.patch.transformer.operation.param.ParamTransformTarget;
import org.sinytra.adapter.patch.transformer.operation.param.ParameterTransformer;
import org.sinytra.adapter.patch.transformer.operation.param.TransformParameters;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.MethodQualifier;

public final class MethodUpgrader {
    public static void upgradeMethod(MethodNode methodNode, MethodContext methodContext, String originalDesc, String modifiedDesc) {
        MethodQualifier cleanQualifier = MethodQualifier.create(originalDesc).orElse(null);
        if (cleanQualifier == null) {
            return;
        }
        MethodQualifier dirtyQualifier = MethodQualifier.create(modifiedDesc).orElse(null);
        if (dirtyQualifier == null) {
            return;
        }
        AnnotationHandle annotation = methodContext.methodAnnotation();
        if (annotation.matchesDesc("Lorg/spongepowered/asm/mixin/injection/ModifyArgs;")) {
            ModifyArgsOffsetTransformer.handleModifiedDesc(methodNode, cleanQualifier.desc(), dirtyQualifier.desc());
        } else if (annotation.matchesDesc("Lcom/llamalad7/mixinextras/injector/wrapoperation/WrapOperation;")) {
            MethodUpgrader.upgradeWrapOperation(methodNode, methodContext, cleanQualifier, dirtyQualifier);
        } else if (annotation.matchesDesc("Lcom/llamalad7/mixinextras/injector/ModifyExpressionValue;")) {
            MethodUpgrader.upgradeModifyExpValue(methodNode, methodContext, cleanQualifier, dirtyQualifier);
        }
    }

    private static void upgradeModifyExpValue(MethodNode methodNode, MethodContext methodContext, MethodQualifier cleanQualifier, MethodQualifier dirtyQualifier) {
        List<Type> originalDesc;
        if (dirtyQualifier.desc() == null || cleanQualifier.desc() == null) {
            return;
        }
        List<Type> originalTargetDesc = List.of(Type.getArgumentTypes((String)cleanQualifier.desc()));
        List<Type> modifiedTargetDesc = List.of(Type.getArgumentTypes((String)dirtyQualifier.desc()));
        List<Type> originalDescRef = originalDesc = List.of(Type.getArgumentTypes((String)methodNode.desc));
        List<Pair> localAnnotations = AdapterUtil.getAnnotatedParameters(methodNode, (Type[])originalDesc.toArray(Type[]::new), "Lcom/llamalad7/mixinextras/sugar/Local;", Pair::of).stream().sorted(Comparator.comparingInt(i -> originalDescRef.indexOf(i.getSecond()))).toList();
        if (!localAnnotations.isEmpty()) {
            originalDesc = originalDesc.subList(0, originalDesc.indexOf(localAnnotations.getFirst().getSecond()));
        }
        if (originalDesc.size() == 1) {
            return;
        }
        int capturedParams = Math.min(originalTargetDesc.size(), originalDesc.size() - 1);
        int popParams = originalTargetDesc.size() - capturedParams;
        ImmutableList modifiedDesc = ImmutableList.builder().add((Object)originalDesc.getFirst()).addAll(modifiedTargetDesc.subList(0, modifiedTargetDesc.size() - popParams)).build();
        SimpleParamsDiffSnapshot diff = EnhancedParamsDiff.create(originalDesc, (List<Type>)modifiedDesc);
        if (!diff.isEmpty()) {
            MethodTransform patch = diff.asParameterTransformer(ParamTransformTarget.ALL, false, Set.of());
            patch.apply(methodContext);
        }
    }

    public static void adjustInjectorOrdinalForNewMethod(MethodInsnNode minsn, MethodContext methodContext) {
        AnnotationValueHandle handle = methodContext.injectionPointAnnotationOrThrow().getValue("ordinal").orElse(null);
        if (handle == null) {
            return;
        }
        int originalOrdinal = (Integer)handle.get();
        if (handle != null) {
            AbstractInsnNode insn;
            handle.set(-1);
            List<AbstractInsnNode> insns = methodContext.computeInjectionTargetInsns(methodContext.findDirtyInjectionTarget());
            handle.set(originalOrdinal);
            int newOrdinal = originalOrdinal;
            ListIterator listIterator = methodContext.findDirtyInjectionTarget().methodNode().instructions.iterator();
            while (listIterator.hasNext() && (insn = (AbstractInsnNode)listIterator.next()) != minsn) {
                if (!insns.contains(insn)) continue;
                --newOrdinal;
            }
            if (newOrdinal >= 0) {
                handle.set(newOrdinal);
            }
        }
    }

    public static void upgradeCapturedLocals(MethodNode methodNode, MethodContext methodContext) {
        AdapterUtil.CapturedLocals capturedLocals = AdapterUtil.getCapturedLocals(methodNode, methodContext);
        if (capturedLocals == null) {
            return;
        }
        List<MethodContext.LocalVariable> availableLocals = methodContext.getTargetMethodLocals(capturedLocals.target());
        if (availableLocals == null || !availableLocals.isEmpty()) {
            return;
        }
        LocalVarAnalyzer.CapturedLocalsTransform transform = LocalVarAnalyzer.analyzeCapturedLocals(capturedLocals, methodNode);
        transform.remover().apply(methodContext);
        List<Type> expected = List.of(Type.getArgumentTypes((String)methodNode.desc));
        ImmutableList required = ImmutableList.builder().add((Object[])Type.getArgumentTypes((String)capturedLocals.target().methodNode().desc)).add((Object)AdapterUtil.getMixinCallableReturnType(capturedLocals.target().methodNode())).build();
        LayeredParamsDiffSnapshot diff = EnhancedParamsDiff.createLayered(expected, (List<Type>)required);
        if (!diff.isEmpty()) {
            List<ParameterTransformer> transformers = diff.modifications().stream().map(paramModification -> paramModification.asParameterTransformer(Set.of())).toList();
            TransformParameters patch = TransformParameters.builder().transform(transformers).withOffset().targetType(ParamTransformTarget.METHOD).build();
            patch.apply(methodContext);
        }
    }

    private static void upgradeWrapOperation(MethodNode methodNode, MethodContext methodContext, MethodQualifier cleanQualifier, MethodQualifier dirtyQualifier) {
        ImmutableList modifiedDesc;
        if (dirtyQualifier.owner() == null || cleanQualifier.desc() == null) {
            return;
        }
        List<Type> originalTargetDesc = List.of(Type.getArgumentTypes((String)cleanQualifier.desc()));
        List<Type> modifiedTargetDesc = List.of(Type.getArgumentTypes((String)dirtyQualifier.desc()));
        List<Type> originalDesc = List.of(Type.getArgumentTypes((String)methodNode.desc));
        SimpleParamsDiffSnapshot diff = EnhancedParamsDiff.create(originalDesc, (List<Type>)(modifiedDesc = ImmutableList.builder().add((Object)Type.getType((String)dirtyQualifier.owner())).addAll(modifiedTargetDesc).addAll(originalDesc.subList(1 + originalTargetDesc.size(), originalDesc.size())).build()));
        if (!diff.isEmpty()) {
            MethodTransform patch = diff.asParameterTransformer(ParamTransformTarget.ALL, false, Set.of());
            patch.apply(methodContext);
        }
    }

    public static void upgradeWrapOperationLayered(MethodContext methodContext, MethodQualifier cleanQualifier, MethodQualifier dirtyQualifier) {
        ImmutableList modifiedDesc;
        if (dirtyQualifier.owner() == null || cleanQualifier.desc() == null) {
            return;
        }
        List<Type> originalTargetDesc = List.of(Type.getArgumentTypes((String)cleanQualifier.desc()));
        List<Type> modifiedTargetDesc = List.of(Type.getArgumentTypes((String)dirtyQualifier.desc()));
        MethodNode methodNode = methodContext.getMixinMethod();
        List<Type> originalDesc = List.of(Type.getArgumentTypes((String)methodNode.desc));
        LayeredParamsDiffSnapshot diff = EnhancedParamsDiff.createLayered(originalDesc, (List<Type>)(modifiedDesc = ImmutableList.builder().add((Object)Type.getType((String)dirtyQualifier.owner())).addAll(modifiedTargetDesc).addAll(originalDesc.subList(1 + originalTargetDesc.size(), originalDesc.size())).build()));
        if (!diff.isEmpty()) {
            MethodTransform patch = diff.asParameterTransformer(ParamTransformTarget.ALL, false, Set.of());
            patch.apply(methodContext);
        }
    }
}

