/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.analysis;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InsnComparator {
    public static final int IGNORE_VAR_INDEX = 1;
    public static final int IGNORE_LINE_NUMBERS = 16;

    public static boolean instructionsEqual(AbstractInsnNode a, AbstractInsnNode b) {
        return InsnComparator.instructionsEqual(a, b, 0);
    }

    public static boolean instructionsEqual(AbstractInsnNode a, AbstractInsnNode b, int flags) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getClass() != b.getClass()) {
            return false;
        }
        if (a.getOpcode() != b.getOpcode()) {
            return false;
        }
        if (a instanceof FieldInsnNode) {
            FieldInsnNode fa = (FieldInsnNode)a;
            FieldInsnNode fb = (FieldInsnNode)b;
            return Objects.equals(fa.owner, fb.owner) && Objects.equals(fa.name, fb.name) && Objects.equals(fa.desc, fb.desc);
        }
        if (a instanceof IincInsnNode) {
            IincInsnNode ia = (IincInsnNode)a;
            IincInsnNode ib = (IincInsnNode)b;
            return ia.var == ib.var && ia.incr == ib.incr;
        }
        if (a instanceof InsnNode) {
            return true;
        }
        if (a instanceof IntInsnNode) {
            IntInsnNode ia = (IntInsnNode)a;
            IntInsnNode ib = (IntInsnNode)b;
            return ia.operand == ib.operand;
        }
        if (a instanceof InvokeDynamicInsnNode) {
            InvokeDynamicInsnNode ia = (InvokeDynamicInsnNode)a;
            InvokeDynamicInsnNode ib = (InvokeDynamicInsnNode)b;
            return Objects.equals(ia.bsm, ib.bsm) && Arrays.equals(ia.bsmArgs, ib.bsmArgs) && Objects.equals(ia.name, ib.name) && Objects.equals(ia.desc, ib.desc);
        }
        if (a instanceof JumpInsnNode || a instanceof LabelNode || a instanceof FrameNode) {
            return true;
        }
        if (a instanceof LdcInsnNode) {
            LdcInsnNode la = (LdcInsnNode)a;
            LdcInsnNode lb = (LdcInsnNode)b;
            return Objects.equals(la.cst, lb.cst);
        }
        if (a instanceof LineNumberNode) {
            LineNumberNode la = (LineNumberNode)a;
            LineNumberNode lb = (LineNumberNode)b;
            return (flags & 0x10) != 0 || la.line == lb.line && InsnComparator.instructionsEqual((AbstractInsnNode)la.start, (AbstractInsnNode)lb.start);
        }
        if (a instanceof LookupSwitchInsnNode) {
            LookupSwitchInsnNode la = (LookupSwitchInsnNode)a;
            LookupSwitchInsnNode lb = (LookupSwitchInsnNode)b;
            return InsnComparator.instructionsEqual((AbstractInsnNode)la.dflt, (AbstractInsnNode)lb.dflt) && Objects.equals(la.keys, lb.keys) && InsnComparator.instructionListsEqual(la.labels, lb.labels);
        }
        if (a instanceof MethodInsnNode) {
            MethodInsnNode ma = (MethodInsnNode)a;
            MethodInsnNode mb = (MethodInsnNode)b;
            return Objects.equals(ma.owner, mb.owner) && Objects.equals(ma.name, mb.name) && Objects.equals(ma.desc, mb.desc) && ma.itf == mb.itf;
        }
        if (a instanceof MultiANewArrayInsnNode) {
            MultiANewArrayInsnNode ma = (MultiANewArrayInsnNode)a;
            MultiANewArrayInsnNode mb = (MultiANewArrayInsnNode)b;
            return Objects.equals(ma.desc, mb.desc) && ma.dims == mb.dims;
        }
        if (a instanceof TableSwitchInsnNode) {
            TableSwitchInsnNode ta = (TableSwitchInsnNode)a;
            TableSwitchInsnNode tb = (TableSwitchInsnNode)b;
            return ta.min == tb.min && ta.max == tb.max && InsnComparator.instructionsEqual((AbstractInsnNode)ta.dflt, (AbstractInsnNode)tb.dflt) && InsnComparator.instructionListsEqual(ta.labels, tb.labels);
        }
        if (a instanceof TypeInsnNode) {
            TypeInsnNode ta = (TypeInsnNode)a;
            TypeInsnNode tb = (TypeInsnNode)b;
            return Objects.equals(ta.desc, tb.desc);
        }
        if (a instanceof VarInsnNode) {
            VarInsnNode va = (VarInsnNode)a;
            VarInsnNode vb = (VarInsnNode)b;
            return (flags & 1) != 0 || va.var == vb.var;
        }
        throw new IllegalArgumentException("Unknown insn type " + a.getClass().getName());
    }

    private static boolean instructionListsEqual(List<? extends AbstractInsnNode> a, List<? extends AbstractInsnNode> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (InsnComparator.instructionsEqual(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }
}

