/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.logging;

import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class DoubleArraySerializer
implements JsonSerializer<double[]> {
    private static final int MAX_ARRAY_SIZE_TO_SERIALIZE = 20;

    public JsonElement serialize(double[] src, Type typeOfSrc, JsonSerializationContext context) {
        if (src.length > 20) {
            return context.serialize((Object)("double[" + src.length + "] too big to print"));
        }
        StringBuilder arrayString = new StringBuilder();
        arrayString.append("[");
        for (int i = 0; i < src.length; ++i) {
            arrayString.append(src[i]);
            if (i >= src.length - 1) continue;
            arrayString.append(", ");
        }
        arrayString.append("]");
        return context.serialize((Object)arrayString.toString());
    }
}

