/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.dimension.CompactDimensionTransitions;
import dev.compactmods.machines.room.Rooms;
import dev.compactmods.machines.server.CompactMachinesServer;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class PlayerUtil {
    public static void resetPlayerHistory(@NotNull ServerPlayer player) {
        player.removeData(Rooms.DataAttachments.LAST_ROOM_ENTRYPOINT);
        CompactMachines.playerHistoryApi().entryPoints().clearHistory(player);
        CompactMachinesServer.savePlayerHistory();
    }

    public static void teleportPlayerToRespawnOrOverworld(MinecraftServer serv, @NotNull ServerPlayer player) {
        ServerLevel level = Optional.ofNullable(serv.getLevel(player.getRespawnDimension())).orElse(serv.overworld());
        Vec3 worldPos = Vec3.atCenterOf((Vec3i)level.getSharedSpawnPos());
        if (player.getRespawnPosition() != null) {
            worldPos = Vec3.atCenterOf((Vec3i)player.getRespawnPosition());
        }
        player.changeDimension(CompactDimensionTransitions.to(level, worldPos));
    }

    public static Optional<GameProfile> getProfileByUUID(MinecraftServer server, UUID uuid) {
        ServerPlayer player = server.getPlayerList().getPlayer(uuid);
        if (player == null) {
            ProfileResult p2 = server.getSessionService().fetchProfile(uuid, false);
            return p2 == null ? Optional.empty() : Optional.ofNullable(p2.profile());
        }
        GameProfile profile = player.getGameProfile();
        return Optional.of(profile);
    }

    public static Optional<GameProfile> getProfileByUUID(LevelAccessor world, UUID uuid) {
        Player player = world.getPlayerByUUID(uuid);
        if (player == null) {
            return Optional.empty();
        }
        GameProfile profile = player.getGameProfile();
        return Optional.of(profile);
    }

    public static Vec2 getLookDirection(Player player) {
        return new Vec2(player.xRotO, player.yRotO);
    }

    public static void breakItemEffect(Player player, ItemStack stack) {
        if (!player.isSilent()) {
            Level l = player.level();
            Vec3 pos = player.position();
            l.playSeededSound(null, pos.x(), pos.y(), pos.z(), stack.getBreakingSound(), player.getSoundSource(), 1.0f, 0.8f + l.random.nextFloat() * 0.4f, player.getRandom().nextLong());
        }
    }
}

