/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.spawn;

import dev.compactmods.machines.api.room.registration.IRoomRegistrar;
import dev.compactmods.machines.api.room.spawn.IRoomSpawnManager;
import dev.compactmods.machines.api.room.spawn.IRoomSpawnManagers;
import dev.compactmods.machines.room.spawn.SpawnManager;
import java.util.HashMap;

public class RoomSpawnManagers
implements IRoomSpawnManagers {
    private final HashMap<String, IRoomSpawnManager> spawnManagers;
    private final IRoomRegistrar roomReg;

    public RoomSpawnManagers(IRoomRegistrar roomReg) {
        this.roomReg = roomReg;
        this.spawnManagers = new HashMap();
        roomReg.allRooms().forEach(roomInstance -> {
            SpawnManager manager = new SpawnManager(roomInstance.code(), roomInstance.boundaries());
            this.spawnManagers.put(roomInstance.code(), manager);
        });
    }

    public IRoomSpawnManager get(String roomCode) {
        return this.spawnManagers.computeIfAbsent(roomCode, code -> this.roomReg.get(roomCode).map(inst -> new SpawnManager(roomCode, inst.boundaries())).orElseThrow());
    }
}

