/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room;

import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import dev.compactmods.machines.CMRegistries;
import dev.compactmods.machines.api.room.history.RoomEntryPoint;
import dev.compactmods.machines.api.room.upgrade.components.RoomUpgradeList;
import dev.compactmods.machines.room.RoomEventHandler;
import dev.compactmods.machines.room.block.SolidWallBlock;
import dev.compactmods.machines.room.ui.upgrades.RoomUpgradeMenu;
import dev.compactmods.machines.room.upgrade.RoomUpgradeInventory;
import dev.compactmods.machines.room.wall.BreakableWallBlock;
import dev.compactmods.machines.room.wall.ItemBlockWall;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;

public interface Rooms {
    public static void prepare() {
        Blocks.prepare();
        Items.prepare();
        Menus.prepare();
        DataAttachments.prepare();
    }

    public static void registerEvents(IEventBus modBus) {
        NeoForge.EVENT_BUS.addListener(RoomEventHandler::checkSpawn);
        NeoForge.EVENT_BUS.addListener(RoomEventHandler::entityChangedDimensions);
        NeoForge.EVENT_BUS.addListener(RoomEventHandler::entityJoined);
        NeoForge.EVENT_BUS.addListener(RoomEventHandler::entityTeleport);
    }

    public static interface Blocks {
        public static final DeferredBlock<SolidWallBlock> SOLID_WALL = CMRegistries.BLOCKS.register("solid_wall", () -> new SolidWallBlock(BlockBehaviour.Properties.of().strength(-1.0f, 3600000.8f).sound(SoundType.METAL).lightLevel(state -> 15)));
        public static final DeferredBlock<BreakableWallBlock> BREAKABLE_WALL = CMRegistries.BLOCKS.register("wall", () -> new BreakableWallBlock(BlockBehaviour.Properties.of().strength(3.0f, 128.0f).requiresCorrectToolForDrops()));

        public static void prepare() {
        }
    }

    public static interface Items {
        public static final Supplier<Item.Properties> WALL_ITEM_PROPS = Item.Properties::new;
        public static final DeferredItem<ItemBlockWall> ITEM_SOLID_WALL = CMRegistries.ITEMS.register("solid_wall", () -> new ItemBlockWall((Block)Blocks.SOLID_WALL.get(), WALL_ITEM_PROPS.get()));
        public static final DeferredItem<ItemBlockWall> BREAKABLE_WALL = CMRegistries.ITEMS.register("wall", () -> new ItemBlockWall((Block)Blocks.BREAKABLE_WALL.get(), WALL_ITEM_PROPS.get()));

        public static void prepare() {
        }
    }

    public static interface Menus {
        public static final DeferredHolder<MenuType<?>, MenuType<RoomUpgradeMenu>> ROOM_UPGRADES = CMRegistries.CONTAINERS.register("room_upgrades", () -> IMenuTypeExtension.create(RoomUpgradeMenu::createClientMenu));

        public static void prepare() {
        }
    }

    public static interface DataAttachments {
        public static final Supplier<AttachmentType<RoomEntryPoint>> LAST_ROOM_ENTRYPOINT = CMRegistries.ATTACHMENT_TYPES.register("last_entrypoint", () -> AttachmentType.builder(() -> RoomEntryPoint.INVALID).serialize(RoomEntryPoint.CODEC).build());
        public static final Supplier<AttachmentType<RoomUpgradeInventory>> UPGRADE_INV = CMRegistries.ATTACHMENT_TYPES.register("upgrades", () -> AttachmentType.serializable(RoomUpgradeInventory::new).build());
        public static final Supplier<AttachmentType<GlobalPos>> OPEN_MACHINE_POS = CMRegistries.ATTACHMENT_TYPES.register("open_machine", () -> AttachmentType.builder(() -> GlobalPos.of((ResourceKey)Level.OVERWORLD, (BlockPos)BlockPos.ZERO)).serialize(GlobalPos.CODEC, (Predicate)Predicates.alwaysFalse()).build());
        public static final Supplier<AttachmentType<RoomUpgradeList>> PERMANENT_UPGRADES = CMRegistries.ATTACHMENT_TYPES.register("permanent_upgrades", () -> AttachmentType.builder(() -> new RoomUpgradeList(List.of())).serialize(RoomUpgradeList.CODEC).build());
        public static final Supplier<AttachmentType<String>> CURRENT_ROOM_CODE = CMRegistries.ATTACHMENT_TYPES.register("current_room_code", () -> AttachmentType.builder(() -> null).serialize((Codec)Codec.STRING).build());

        public static void prepare() {
        }
    }
}

