/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room;

import dev.compactmods.machines.LoggingUtil;
import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.dimension.CompactDimension;
import dev.compactmods.machines.api.dimension.MissingDimensionException;
import dev.compactmods.machines.api.location.GlobalPosWithRotation;
import dev.compactmods.machines.api.room.RoomInstance;
import dev.compactmods.machines.api.room.history.IPlayerEntryPointHistoryManager;
import dev.compactmods.machines.api.room.history.PlayerRoomHistoryEntry;
import dev.compactmods.machines.api.room.history.RoomEntryPoint;
import dev.compactmods.machines.api.room.history.RoomEntryResult;
import dev.compactmods.machines.api.room.history.RoomExitResult;
import dev.compactmods.machines.api.room.spawn.IRoomSpawn;
import dev.compactmods.machines.api.room.spawn.IRoomSpawns;
import dev.compactmods.machines.dimension.CompactDimensionTransitions;
import dev.compactmods.machines.network.room.SyncRoomMetadataPacket;
import dev.compactmods.machines.room.Rooms;
import dev.compactmods.machines.shrinking.Shrinking;
import dev.compactmods.machines.util.PlayerUtil;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.Logger;

public abstract class RoomHelper {
    private static final Logger LOGS = LoggingUtil.modLog();

    public static boolean entityInsideRoom(LivingEntity entity, String roomCode) {
        if (entity.level().dimension().equals(CompactDimension.LEVEL_KEY)) {
            return CompactMachines.roomApi().chunks(roomCode).hasChunk(entity.chunkPosition());
        }
        return false;
    }

    public static CompletableFuture<RoomEntryResult> teleportPlayerIntoMachine(Level machineLevel, ServerPlayer player, GlobalPos machinePos, String roomCode) {
        MinecraftServer serv = machineLevel.getServer();
        LOGS.debug("Player {} entering machine at: {}", (Object)player.getName(), (Object)machinePos);
        return CompactMachines.room((String)roomCode).map(roomInfo -> {
            try {
                return RoomHelper.teleportPlayerIntoRoom(serv, player, roomInfo, RoomEntryPoint.playerEnteringMachine((Player)player));
            }
            catch (MissingDimensionException e) {
                LOGS.fatal("Critical error; could not enter a freshly-created room instance.", (Throwable)e);
                return CompletableFuture.completedFuture(RoomEntryResult.FAILED_ROOM_INVALID);
            }
        }).orElse(CompletableFuture.completedFuture(RoomEntryResult.FAILED_ROOM_INVALID));
    }

    public static CompletableFuture<RoomEntryResult> teleportPlayerIntoRoom(MinecraftServer serv, ServerPlayer player, RoomInstance room, RoomEntryPoint entryPoint) throws MissingDimensionException {
        ServerLevel compactDim = CompactDimension.forServer((MinecraftServer)serv);
        IPlayerEntryPointHistoryManager history = CompactMachines.playerHistoryApi().entryPoints();
        RoomEntryResult result = history.enterRoom((Player)player, room.code(), entryPoint);
        if (result == RoomEntryResult.FAILED_TOO_FAR_DOWN) {
            player.displayClientMessage((Component)Component.translatableWithFallback((String)"compactmachines.errors.too_far_down", (String)"An otherworldly force prevents you from shrinking more.").withStyle(ChatFormatting.DARK_RED).withStyle(ChatFormatting.ITALIC), true);
            return CompletableFuture.completedFuture(result);
        }
        if (result.successful()) {
            player.setData(Rooms.DataAttachments.CURRENT_ROOM_CODE, (Object)room.code());
            player.setData(Rooms.DataAttachments.LAST_ROOM_ENTRYPOINT, (Object)RoomEntryPoint.playerEnteringMachine((Player)player));
            return serv.submit(() -> {
                player.getCooldowns().addCooldown((Item)Shrinking.PERSONAL_SHRINKING_DEVICE.get(), 25);
                IRoomSpawns spawns = CompactMachines.roomApi().spawnManager(room.code()).spawns();
                IRoomSpawn spawn = spawns.forPlayer(player.getUUID()).orElse(spawns.defaultSpawn());
                player.changeDimension(CompactDimensionTransitions.to(compactDim, spawn.position(), spawn.rotation()));
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncRoomMetadataPacket(room.code(), Util.NIL_UUID), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return result;
            });
        }
        return CompletableFuture.completedFuture(result);
    }

    public static CompletableFuture<RoomExitResult> teleportPlayerOutOfRoom(@Nonnull ServerPlayer serverPlayer) {
        if (!CompactDimension.isLevelCompact((Level)serverPlayer.level())) {
            return CompletableFuture.completedFuture(RoomExitResult.FAILED_NOT_IN_COMPACT_DIM);
        }
        MinecraftServer serv = serverPlayer.getServer();
        assert (serv != null);
        IPlayerEntryPointHistoryManager history = CompactMachines.playerHistoryApi().entryPoints();
        return serv.submit(() -> {
            PlayerRoomHistoryEntry lastHistory = history.lastHistory((Player)serverPlayer).orElse(null);
            if (lastHistory != null) {
                serverPlayer.getCooldowns().addCooldown((Item)Shrinking.PERSONAL_SHRINKING_DEVICE.get(), 25);
                serverPlayer.setData(Rooms.DataAttachments.LAST_ROOM_ENTRYPOINT, (Object)lastHistory.entryPoint());
                history.popHistory((Player)serverPlayer, 1);
                serverPlayer.setData(Rooms.DataAttachments.CURRENT_ROOM_CODE, (Object)lastHistory.roomCode());
                GlobalPosWithRotation location = lastHistory.entryPoint().entryLocation();
                ServerLevel level = serv.getLevel(location.dimension());
                if (level != null) {
                    LOGS.debug("Teleporting player {} to {} as they jump up a level...", (Object)serverPlayer.getUUID(), (Object)location);
                    serverPlayer.changeDimension(CompactDimensionTransitions.to(level, location.position(), location.rotation()));
                    return RoomExitResult.SUCCESS_WENT_TO_LAST_ENTRYPOINT;
                }
                LOGS.error("Player tracking points to an unknown dimension. Teleporting player {} to their default spawn instead.", (Object)serverPlayer.getUUID());
                PlayerUtil.teleportPlayerToRespawnOrOverworld(serv, serverPlayer);
                return RoomExitResult.SUCCESS_WENT_TO_SPAWN;
            }
            serverPlayer.removeData(Rooms.DataAttachments.LAST_ROOM_ENTRYPOINT);
            PlayerUtil.teleportPlayerToRespawnOrOverworld(serv, serverPlayer);
            return RoomExitResult.SUCCESS_WENT_TO_SPAWN;
        });
    }
}

