/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine.block;

import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.machine.MachineColor;
import dev.compactmods.machines.api.machine.block.IBoundCompactMachineBlockEntity;
import dev.compactmods.machines.machine.MachineColors;
import dev.compactmods.machines.machine.Machines;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoundCompactMachineBlockEntity
extends BlockEntity
implements IBoundCompactMachineBlockEntity {
    protected UUID owner;
    private String roomCode;
    @Nullable
    private Component customName;

    public BoundCompactMachineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Machines.BlockEntities.MACHINE.get(), pos, state);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        super.applyImplicitComponents(components);
        this.roomCode = (String)components.get(Machines.DataComponents.BOUND_ROOM_CODE);
        MachineColor desiredColor = (MachineColor)components.get(Machines.DataComponents.MACHINE_COLOR);
        if (desiredColor != null) {
            this.setData(Machines.Attachments.MACHINE_COLOR, desiredColor);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(Machines.DataComponents.BOUND_ROOM_CODE, (Object)this.roomCode);
        builder.set(Machines.DataComponents.MACHINE_COLOR, (Object)((MachineColor)this.getData(Machines.Attachments.MACHINE_COLOR)));
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("room_code");
        tag.remove("machine_color");
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider holders) {
        super.loadAdditional(nbt, holders);
        if (nbt.contains("room_code")) {
            this.roomCode = nbt.getString("room_code");
        }
        this.owner = nbt.contains("owner") ? nbt.getUUID("owner") : null;
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, HolderLookup.Provider holders) {
        super.saveAdditional(nbt, holders);
        if (this.owner != null) {
            nbt.putUUID("owner", this.owner);
        }
        if (this.roomCode != null) {
            nbt.putString("room_code", this.roomCode);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag data = super.getUpdateTag(provider);
        this.saveAdditional(data, provider);
        if (this.roomCode != null) {
            data.putString("room_code", this.roomCode);
        }
        if (this.owner != null) {
            data.putUUID("owner", this.owner);
        }
        return data;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        if (tag.contains("room_code")) {
            this.roomCode = tag.getString("room_code");
        }
        if (tag.contains("players")) {
            CompoundTag compoundTag = tag.getCompound("players");
        }
        if (tag.contains("owner")) {
            this.owner = tag.getUUID("owner");
        }
    }

    public Optional<UUID> getOwnerUUID() {
        return Optional.ofNullable(this.owner);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public boolean hasPlayersInside() {
        return false;
    }

    public GlobalPos getLevelPosition() {
        return GlobalPos.of((ResourceKey)this.level.dimension(), (BlockPos)this.worldPosition);
    }

    public void setConnectedRoom(String roomCode) {
        if (this.level != null && !this.level.isClientSide()) {
            this.roomCode = roomCode;
            CompactMachines.room((String)roomCode).ifPresentOrElse(inst -> this.setData(Machines.Attachments.MACHINE_COLOR, inst.defaultMachineColor()), () -> this.setData(Machines.Attachments.MACHINE_COLOR, MachineColors.WHITE));
            this.setChanged();
        }
    }

    @NotNull
    public String connectedRoom() {
        return this.roomCode;
    }

    public Optional<Component> getCustomName() {
        return Optional.ofNullable(this.customName);
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
        this.setChanged();
    }
}

