/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.neoforged.neoforge.common.IOUtilities;

public class DataFileUtil {
    public static void ensureDirExists(Path dir) {
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T loadFileWithCodec(File file, Codec<T> codec) {
        try {
            IOUtilities.cleanupTempFiles((Path)Path.of(file.getParent(), new String[0]), (String)file.getName());
            try (FileInputStream is = new FileInputStream(file);){
                CompoundTag tag = NbtIo.readCompressed((InputStream)is, (NbtAccounter)NbtAccounter.unlimitedHeap());
                Object object = codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)(tag.contains("data") ? tag.getCompound("data") : new CompoundTag())).getOrThrow();
                return (T)object;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

