/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.util.PlayerUtil;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class CMEjectSubcommand {
    public static ArgumentBuilder<CommandSourceStack, ?> make() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"eject").executes(CMEjectSubcommand::execExecutingPlayer)).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(cs -> cs.hasPermission(2))).executes(CMEjectSubcommand::execSpecificPlayer));
    }

    private static int execSpecificPlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection ent = EntityArgument.getPlayers(ctx, (String)"player");
        ent.forEach(player -> {
            CompactMachines.playerHistoryApi().entryPoints().clearHistory(player);
            PlayerUtil.teleportPlayerToRespawnOrOverworld(((CommandSourceStack)ctx.getSource()).getServer(), player);
        });
        return 0;
    }

    private static int execExecutingPlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        server.submitAsync(() -> CompactMachines.playerHistoryApi().entryPoints().clearHistory(player));
        PlayerUtil.teleportPlayerToRespawnOrOverworld(((CommandSourceStack)ctx.getSource()).getServer(), player);
        return 0;
    }
}

