/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.ingredient;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.commoncapabilities.CommonCapabilities;
import org.cyclops.commoncapabilities.GeneralConfig;

public class DataComparator
implements Comparator<DataComponentMap> {
    public static Comparator<DataComponentMap> INSTANCE = new DataComparator(null);
    private final Set<ResourceLocation> ignoreDataComponentTypes;
    private Set<DataComponentType<?>> ignoreDataComponentTypeInstances;

    public DataComparator(@Nullable Set<ResourceLocation> ignoreDataComponentTypes) {
        this.ignoreDataComponentTypes = ignoreDataComponentTypes;
    }

    @Override
    public int compare(DataComponentMap o1, DataComponentMap o2) {
        return this.compare(o1, o2, this.ignoreDataComponentTypes);
    }

    protected int compare(DataComponentMap o1, DataComponentMap o2, @Nullable Set<ResourceLocation> ignoreDataComponentTypes) {
        if (o1 == o2 || o1.equals((Object)o2)) {
            return 0;
        }
        Set k1 = o1.keySet();
        Set k2 = o2.keySet();
        if (ignoreDataComponentTypes != null) {
            if (this.ignoreDataComponentTypeInstances == null) {
                this.ignoreDataComponentTypeInstances = ignoreDataComponentTypes.stream().map(arg_0 -> ((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE).get(arg_0)).collect(Collectors.toSet());
            }
            boolean filterK1 = false;
            boolean filterK2 = false;
            for (DataComponentType<?> dataComponentType : this.ignoreDataComponentTypeInstances) {
                if (!filterK1 && k1.contains(dataComponentType)) {
                    filterK1 = true;
                }
                if (!filterK2 && k2.contains(dataComponentType)) {
                    filterK2 = true;
                }
                if (!filterK1 || !filterK2) continue;
                break;
            }
            if (filterK1) {
                k1 = k1.stream().filter(k -> !this.ignoreDataComponentTypeInstances.contains(k)).collect(Collectors.toSet());
            }
            if (filterK2) {
                k2 = k2.stream().filter(k -> !this.ignoreDataComponentTypeInstances.contains(k)).collect(Collectors.toSet());
            }
        }
        if (!k1.equals(k2)) {
            Object[] k1a = (String[])k1.stream().map(k -> BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(k).toString()).toArray(String[]::new);
            Object[] k2a = (String[])k2.stream().map(k -> BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(k).toString()).toArray(String[]::new);
            Arrays.sort(k1a);
            Arrays.sort(k2a);
            int minLength = Math.min(k1a.length, k2a.length);
            for (int i = 0; i < minLength; ++i) {
                int result = ((String)k1a[i]).compareTo((String)k2a[i]);
                if (result == 0) continue;
                return result;
            }
            return k1a.length - k2a.length;
        }
        for (DataComponentType key : k1) {
            int comp = this.compareRaw(o1.get(key), o2.get(key));
            if (comp == 0) continue;
            if (GeneralConfig.debugLogUnequalItemDataComponents) {
                CommonCapabilities.clog(String.format("Data component mismatch on key '%s' for values '%s' and '%s'.", key, o1.get(key), o2.get(key)));
            }
            return comp;
        }
        return 0;
    }

    private int compareRaw(Object o1, Object o2) {
        if (o1 == o2 || o1.equals(o2)) {
            return 0;
        }
        if (o1 instanceof Comparable) {
            Comparable comparable = (Comparable)o1;
            return comparable.compareTo(o2);
        }
        return Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));
    }
}

