/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.inventorystate;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.cyclops.commoncapabilities.api.capability.inventorystate.IInventoryState;

public class ItemHandlerInventoryState
implements IInventoryState,
IItemHandler {
    private final IItemHandler itemHandler;
    private int hash;

    public ItemHandlerInventoryState(IItemHandler itemHandler) {
        this.itemHandler = Objects.requireNonNull(itemHandler);
    }

    protected void setNewHash() {
        ++this.hash;
    }

    @Override
    public int getState() {
        return this.hash;
    }

    public int getSlots() {
        return this.itemHandler.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!simulate) {
            this.setNewHash();
        }
        return this.itemHandler.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!simulate) {
            this.setNewHash();
        }
        return this.itemHandler.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.itemHandler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack itemStack) {
        return this.itemHandler.isItemValid(slot, itemStack);
    }
}

