/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.render;

import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerTabOverlay;
import net.minecraft.util.Mth;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.api.heart.drawing.Heart;
import terrails.colorfulhearts.render.HeartUtils;

public class TabHeartRenderer {
    public static final TabHeartRenderer INSTANCE = new TabHeartRenderer();
    private final Minecraft client = Minecraft.getInstance();
    private Heart[] hearts;
    public int lastHealth;
    public int lastDisplayHealth;

    public void renderPlayerListHud(int y, int x, int offset, GuiGraphics guiGraphics, int health, PlayerTabOverlay.HealthState healthState) {
        if (health != this.lastHealth || healthState.displayedValue() != this.lastDisplayHealth || this.hearts == null) {
            int value = Math.max(health, healthState.displayedValue());
            this.hearts = HeartUtils.calculateHearts(null, value, value, 0);
            this.lastHealth = health;
            this.lastDisplayHealth = healthState.displayedValue();
            CColorfulHearts.LOGGER.debug("Successfully updated tab hearts.\n{}", (Object)Arrays.toString(this.hearts));
        }
        health = Math.min(health, 20);
        int displayHealth = Math.min(healthState.displayedValue(), 20);
        int displayHealthHearts = Mth.ceil((double)((double)displayHealth / 2.0));
        boolean blinking = healthState.isBlinking((long)this.client.gui.getGuiTicks());
        int spacingDivisor = Math.max(health, displayHealth) / 2;
        int spacingMultiplier = Mth.floor((float)Math.min((float)(offset - x - 4) / (float)spacingDivisor, 9.0f));
        boolean hardcore = CColorfulHearts.PROXY.forcedHardcoreHearts() || this.client.level != null && this.client.level.getLevelData().isHardcore();
        for (int i = 0; i < this.hearts.length; ++i) {
            Heart heart = this.hearts[i];
            if (heart == null) continue;
            int xPos = x + i % 10 * spacingMultiplier;
            boolean blinkingHeart = blinking && i < displayHealthHearts;
            heart.draw(guiGraphics, xPos, y, hardcore, blinking, blinkingHeart);
        }
    }
}

