/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.render;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.function.IntUnaryOperator;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class ImageUtils {
    public static void blendNormal(NativeImage base, NativeImage blend) {
        int width = Math.max(base.getWidth(), blend.getWidth());
        int height = Math.max(base.getHeight(), blend.getHeight());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int pixelBase = base.isOutsideBounds(x, y) ? 0 : base.getPixelRGBA(x, y);
                int pixelBlend = blend.isOutsideBounds(x, y) ? 0 : blend.getPixelRGBA(x, y);
                int alphaBackground = FastColor.ABGR32.alpha((int)pixelBase);
                if (alphaBackground == 0) {
                    base.setPixelRGBA(x, y, pixelBlend);
                    continue;
                }
                int blueBackground = FastColor.ABGR32.blue((int)pixelBase);
                int greenBackground = FastColor.ABGR32.green((int)pixelBase);
                int redBackground = FastColor.ABGR32.red((int)pixelBase);
                int alphaForeground = FastColor.ABGR32.alpha((int)pixelBlend);
                if (alphaForeground == 0) continue;
                int blueForeground = FastColor.ABGR32.blue((int)pixelBlend);
                int greenForeground = FastColor.ABGR32.green((int)pixelBlend);
                int redForeground = FastColor.ABGR32.red((int)pixelBlend);
                int alphaInvert = 255 - alphaForeground;
                int alpha = Math.max(alphaForeground, alphaBackground);
                int blue = Mth.clamp((int)((blueForeground * alphaForeground + blueBackground * alphaInvert) / 255), (int)0, (int)255);
                int green = Mth.clamp((int)((greenForeground * alphaForeground + greenBackground * alphaInvert) / 255), (int)0, (int)255);
                int red = Mth.clamp((int)((redForeground * alphaForeground + redBackground * alphaInvert) / 255), (int)0, (int)255);
                int color = FastColor.ABGR32.color((int)alpha, (int)blue, (int)green, (int)red);
                base.setPixelRGBA(x, y, color);
            }
        }
    }

    public static void blendMultiply(NativeImage base, NativeImage blend) {
        int width = Math.max(base.getWidth(), blend.getWidth());
        int height = Math.max(base.getHeight(), blend.getHeight());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int pixelBase = base.isOutsideBounds(x, y) ? 0 : base.getPixelRGBA(x, y);
                int pixelBlend = blend.isOutsideBounds(x, y) ? 0 : blend.getPixelRGBA(x, y);
                int alphaBase = FastColor.ABGR32.alpha((int)pixelBase);
                if (alphaBase == 0) {
                    base.setPixelRGBA(x, y, pixelBlend);
                    continue;
                }
                int alphaBlend = FastColor.ABGR32.alpha((int)pixelBlend);
                if (alphaBlend == 0) continue;
                int blueBase = FastColor.ABGR32.blue((int)pixelBase);
                int greenBase = FastColor.ABGR32.green((int)pixelBase);
                int redBase = FastColor.ABGR32.red((int)pixelBase);
                int blueBlend = FastColor.ABGR32.blue((int)pixelBlend);
                int greenBlend = FastColor.ABGR32.green((int)pixelBlend);
                int redBlend = FastColor.ABGR32.red((int)pixelBlend);
                int alpha = Math.max(alphaBase, alphaBlend);
                int blue = blueBase * blueBlend / 255;
                int green = greenBase * greenBlend / 255;
                int red = redBase * redBlend / 255;
                int color = FastColor.ABGR32.color((int)alpha, (int)blue, (int)green, (int)red);
                base.setPixelRGBA(x, y, color);
            }
        }
    }

    public static void blendScreen(NativeImage base, NativeImage blend) {
        int width = Math.max(base.getWidth(), blend.getWidth());
        int height = Math.max(base.getHeight(), blend.getHeight());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int pixelBase = base.isOutsideBounds(x, y) ? 0 : base.getPixelRGBA(x, y);
                int pixelBlend = blend.isOutsideBounds(x, y) ? 0 : blend.getPixelRGBA(x, y);
                int alphaBase = FastColor.ABGR32.alpha((int)pixelBase);
                if (alphaBase == 0) {
                    base.setPixelRGBA(x, y, pixelBlend);
                    continue;
                }
                int alphaBlend = FastColor.ABGR32.alpha((int)pixelBlend);
                if (alphaBlend == 0) continue;
                int blueBase = FastColor.ABGR32.blue((int)pixelBase);
                int greenBase = FastColor.ABGR32.green((int)pixelBase);
                int redBase = FastColor.ABGR32.red((int)pixelBase);
                int blueBlend = FastColor.ABGR32.blue((int)pixelBlend);
                int greenBlend = FastColor.ABGR32.green((int)pixelBlend);
                int redBlend = FastColor.ABGR32.red((int)pixelBlend);
                int alpha = Math.max(alphaBase, alphaBlend);
                int blue = Mth.clamp((int)(255 - (255 - blueBase) * (255 - blueBlend) / 255), (int)0, (int)255);
                int green = Mth.clamp((int)(255 - (255 - greenBase) * (255 - greenBlend) / 255), (int)0, (int)255);
                int red = Mth.clamp((int)(255 - (255 - redBase) * (255 - redBlend) / 255), (int)0, (int)255);
                int color = FastColor.ABGR32.color((int)alpha, (int)blue, (int)green, (int)red);
                base.setPixelRGBA(x, y, color);
            }
        }
    }

    public static void blendOverlay(NativeImage base, NativeImage blend) {
        int width = Math.max(base.getWidth(), blend.getWidth());
        int height = Math.max(base.getHeight(), blend.getHeight());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int pixelBase = base.isOutsideBounds(x, y) ? 0 : base.getPixelRGBA(x, y);
                int pixelBlend = blend.isOutsideBounds(x, y) ? 0 : blend.getPixelRGBA(x, y);
                int alphaBase = FastColor.ABGR32.alpha((int)pixelBase);
                if (alphaBase == 0) {
                    base.setPixelRGBA(x, y, pixelBlend);
                    continue;
                }
                int alphaBlend = FastColor.ABGR32.alpha((int)pixelBlend);
                if (alphaBlend == 0) continue;
                int blueBase = FastColor.ABGR32.blue((int)pixelBase);
                int greenBase = FastColor.ABGR32.green((int)pixelBase);
                int redBase = FastColor.ABGR32.red((int)pixelBase);
                int blueBlend = FastColor.ABGR32.blue((int)pixelBlend);
                int greenBlend = FastColor.ABGR32.green((int)pixelBlend);
                int redBlend = FastColor.ABGR32.red((int)pixelBlend);
                int alpha = Math.max(alphaBase, alphaBlend);
                int blue = blueBase < 128 ? Mth.clamp((int)(2 * (blueBase * blueBlend / 255)), (int)0, (int)255) : Mth.clamp((int)(255 - 2 * (alphaBlend - blueBase) * (alphaBase - blueBlend) / 255), (int)0, (int)255);
                int green = greenBase < 128 ? Mth.clamp((int)(2 * (greenBase * greenBlend / 255)), (int)0, (int)255) : Mth.clamp((int)(255 - 2 * (alphaBlend - greenBase) * (alphaBase - greenBlend) / 255), (int)0, (int)255);
                int red = redBase < 128 ? Mth.clamp((int)(2 * (redBase * redBlend / 255)), (int)0, (int)255) : Mth.clamp((int)(255 - 2 * (alphaBlend - redBase) * (alphaBase - redBlend) / 255), (int)0, (int)255);
                int color = FastColor.ABGR32.color((int)alpha, (int)blue, (int)green, (int)red);
                base.setPixelRGBA(x, y, color);
            }
        }
    }

    public static IntUnaryOperator getColorOverlayOperator(int redColor, int greenColor, int blueColor) {
        return pixel -> {
            int alphaBase = FastColor.ABGR32.alpha((int)pixel);
            if (alphaBase == 0) {
                return pixel;
            }
            int blueBase = FastColor.ABGR32.blue((int)pixel);
            int greenBase = FastColor.ABGR32.green((int)pixel);
            int redBase = FastColor.ABGR32.red((int)pixel);
            int blue = blueBase < 128 ? 2 * (blueBase * blueColor / 255) : 255 - 2 * (255 - blueBase) * (alphaBase - blueColor) / 255;
            int green = greenBase < 128 ? 2 * (greenBase * greenColor / 255) : 255 - 2 * (255 - greenBase) * (alphaBase - greenColor) / 255;
            int red = redBase < 128 ? 2 * (redBase * redColor / 255) : 255 - 2 * (255 - redBase) * (alphaBase - redColor) / 255;
            return FastColor.ABGR32.color((int)alphaBase, (int)blue, (int)green, (int)red);
        };
    }

    public static IntUnaryOperator getColorOverlayOperator(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return ImageUtils.getColorOverlayOperator(r, g, b);
    }
}

