/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.neoforge;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterSpriteSourceTypesEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.config.ConfigOption;
import terrails.colorfulhearts.config.ConfigUtils;
import terrails.colorfulhearts.config.Configuration;
import terrails.colorfulhearts.config.screen.ConfigurationScreen;
import terrails.colorfulhearts.neoforge.PlatformProxyImpl;
import terrails.colorfulhearts.neoforge.render.RenderEventHandler;
import terrails.colorfulhearts.render.atlas.sources.ColoredHearts;

@Mod(value="colorfulhearts", dist={Dist.CLIENT})
public class ColorfulHearts {
    public static ModConfigSpec CONFIG_SPEC;
    private static final List<ConfigOption<?, ?>> CONFIG_OPTIONS;
    private static final Map<String, String> COMPAT;

    public ColorfulHearts(IEventBus bus, ModContainer container) {
        CColorfulHearts.setup(new PlatformProxyImpl());
        CONFIG_SPEC = this.setupConfig();
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CONFIG_SPEC, "colorfulhearts.toml");
        container.registerExtensionPoint(IConfigScreenFactory.class, () -> (mc, lastScreen) -> new ConfigurationScreen(lastScreen));
        bus.addListener(this::setup);
        bus.addListener(this::registerSprite);
        bus.addListener(this::loadConfig);
        bus.addListener(this::reloadConfig);
        this.setupCompat(bus);
    }

    private void setup(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, RenderEventHandler.INSTANCE::renderHearts);
    }

    private void registerSprite(RegisterSpriteSourceTypesEvent event) {
        ColoredHearts.TYPE = event.register(ResourceLocation.fromNamespaceAndPath((String)"colorfulhearts", (String)"colored_hearts"), ColoredHearts.CODEC);
    }

    private void loadConfig(ModConfigEvent.Loading event) {
        CColorfulHearts.LOGGER.info("Loading {} config file", (Object)event.getConfig().getFileName());
        CONFIG_OPTIONS.forEach(ConfigOption::reload);
        ConfigUtils.loadColoredHearts();
        ConfigUtils.loadStatusEffectHearts();
        CColorfulHearts.LOGGER.debug("Loaded {} config file", (Object)event.getConfig().getFileName());
    }

    private void reloadConfig(ModConfigEvent.Reloading event) {
        CColorfulHearts.LOGGER.info("Reloading {} config file", (Object)event.getConfig().getFileName());
        CONFIG_OPTIONS.forEach(ConfigOption::reload);
        ConfigUtils.loadColoredHearts();
        ConfigUtils.loadStatusEffectHearts();
        CColorfulHearts.LOGGER.debug("Reloaded {} config file", (Object)event.getConfig().getFileName());
    }

    private ModConfigSpec setupConfig() {
        ModConfigSpec.Builder specBuilder = new ModConfigSpec.Builder();
        for (Object instance : new Object[]{Configuration.HEALTH, Configuration.ABSORPTION}) {
            for (Field field : instance.getClass().getDeclaredFields()) {
                try {
                    Object object = field.get(instance);
                    if (object instanceof ConfigOption) {
                        ModConfigSpec.ConfigValue value;
                        ConfigOption option = (ConfigOption)object;
                        CONFIG_OPTIONS.add(option);
                        Object c = option.getRawDefault();
                        if (c instanceof List) {
                            List list = (List)c;
                            value = specBuilder.comment(option.getComment()).defineList(option.getPath(), list, null, option.getOptionValidator());
                        } else {
                            value = specBuilder.comment(option.getComment()).define(option.getPath(), option.getRawDefault(), option.getOptionValidator());
                        }
                        option.initialize(value, arg_0 -> ((ModConfigSpec.ConfigValue)value).set(arg_0));
                        continue;
                    }
                    CColorfulHearts.LOGGER.debug("Skipping {} field in {} as it is not a ConfigOption", (Object)field.getName(), (Object)instance.getClass().getName());
                }
                catch (IllegalAccessException e) {
                    CColorfulHearts.LOGGER.error("Could not process {} field in {}", (Object)field.getName(), (Object)instance.getClass().getName(), (Object)e);
                }
            }
        }
        return specBuilder.build();
    }

    private void setupCompat(IEventBus bus) {
        String basePackage = "terrails.colorfulhearts.neoforge.compat";
        for (Map.Entry<String, String> entry : COMPAT.entrySet()) {
            String id = entry.getKey();
            if (ModList.get().isLoaded(id)) {
                String className = "terrails.colorfulhearts.neoforge.compat." + entry.getValue();
                CColorfulHearts.LOGGER.info("Loading compat for mod {}", (Object)id);
                try {
                    Class<?> compatClass = Class.forName(className);
                    try {
                        compatClass.getDeclaredConstructor(IEventBus.class).newInstance(bus);
                    }
                    catch (NoSuchMethodException ignored) {
                        compatClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                }
                catch (ClassNotFoundException e) {
                    CColorfulHearts.LOGGER.error("Failed to load compat as {} does not exist", (Object)className, (Object)e);
                }
                catch (NoSuchMethodException e) {
                    CColorfulHearts.LOGGER.error("Failed to load compat as {} does not have a valid constructor", (Object)className, (Object)e);
                }
                catch (IllegalAccessException e) {
                    CColorfulHearts.LOGGER.error("Failed to load compat as {} does not have a valid public constructor", (Object)className, (Object)e);
                }
                catch (InstantiationException e) {
                    CColorfulHearts.LOGGER.error("Failed to load compat as {} is an abstract class", (Object)className, (Object)e);
                }
                catch (InvocationTargetException e) {
                    CColorfulHearts.LOGGER.error("Failed to load compat {} as an unknown error was thrown", (Object)className, (Object)e);
                }
                continue;
            }
            CColorfulHearts.LOGGER.debug("Skipped loading compat for missing mod {}", (Object)id);
        }
    }

    static {
        CONFIG_OPTIONS = new ArrayList();
        COMPAT = Map.of("appleskin", "AppleSkinCompat", "undergarden", "UndergardenCompat");
    }
}

