/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.autoconfig;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.ConfigManager;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.gui.ConfigScreenProvider;
import me.shedaniel.autoconfig.gui.DefaultGuiProviders;
import me.shedaniel.autoconfig.gui.DefaultGuiTransformers;
import me.shedaniel.autoconfig.gui.registry.ComposedGuiRegistryAccess;
import me.shedaniel.autoconfig.gui.registry.DefaultGuiRegistryAccess;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AutoConfig {
    public static final String MOD_ID = "autoconfig1u";
    private static final Map<Class<? extends ConfigData>, ConfigHolder<?>> holders = new HashMap();
    private static final Map<Class<? extends ConfigData>, GuiRegistry> guiRegistries = new HashMap<Class<? extends ConfigData>, GuiRegistry>();

    private AutoConfig() {
    }

    public static <T extends ConfigData> ConfigHolder<T> register(Class<T> configClass, ConfigSerializer.Factory<T> serializerFactory) {
        Objects.requireNonNull(configClass);
        Objects.requireNonNull(serializerFactory);
        if (holders.containsKey(configClass)) {
            throw new RuntimeException(String.format("Config '%s' already registered", configClass));
        }
        Config definition = configClass.getAnnotation(Config.class);
        if (definition == null) {
            throw new RuntimeException(String.format("No @Config annotation on %s!", configClass));
        }
        ConfigSerializer<T> serializer = serializerFactory.create(definition, configClass);
        ConfigManager<T> manager = new ConfigManager<T>(definition, configClass, serializer);
        holders.put(configClass, manager);
        return manager;
    }

    public static <T extends ConfigData> ConfigHolder<T> getConfigHolder(Class<T> configClass) {
        Objects.requireNonNull(configClass);
        if (holders.containsKey(configClass)) {
            return holders.get(configClass);
        }
        throw new RuntimeException(String.format("Config '%s' has not been registered", configClass));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends ConfigData> GuiRegistry getGuiRegistry(Class<T> configClass) {
        return guiRegistries.computeIfAbsent(configClass, n -> new GuiRegistry());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends ConfigData> Supplier<Screen> getConfigScreen(Class<T> configClass, Screen parent) {
        return new ConfigScreenProvider((ConfigManager)AutoConfig.getConfigHolder(configClass), new ComposedGuiRegistryAccess(AutoConfig.getGuiRegistry(configClass), ClientOnly.defaultGuiRegistry, new DefaultGuiRegistryAccess()), parent);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientOnly {
        private static final GuiRegistry defaultGuiRegistry = DefaultGuiTransformers.apply(DefaultGuiProviders.apply(new GuiRegistry()));

        private ClientOnly() {
        }
    }
}

