/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.neoforge.common.inventory;

import java.util.List;
import java.util.UUID;
import net.chococraft.common.inventory.SaddleBagMenu;
import net.chococraft.common.items.ChocoboSaddleItem;
import net.chococraft.neoforge.common.entity.NeoForgeChocobo;
import net.chococraft.neoforge.common.inventory.SlotChocoboSaddle;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class NeoForgeSaddleBagMenu
extends SaddleBagMenu {
    private final NeoForgeChocobo forgeChocobo;

    public NeoForgeSaddleBagMenu(int id, Inventory inventory, NeoForgeChocobo chocobo) {
        super(id, inventory, chocobo);
        this.forgeChocobo = chocobo;
        this.refreshSlots(chocobo, inventory);
    }

    public static NeoForgeSaddleBagMenu create(int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        UUID uuid = buffer.readUUID();
        List chocobos = inventory.player.level().getEntitiesOfClass(NeoForgeChocobo.class, inventory.player.getBoundingBox().inflate(16.0), test -> test.getUUID().equals(uuid));
        NeoForgeChocobo chocobo = chocobos.isEmpty() ? null : (NeoForgeChocobo)((Object)chocobos.getFirst());
        return new NeoForgeSaddleBagMenu(windowId, inventory, chocobo);
    }

    public NeoForgeChocobo getChocobo() {
        return this.forgeChocobo;
    }

    public void refreshSlots(final NeoForgeChocobo chocobo, Inventory inventory) {
        int col;
        int row;
        this.slots.clear();
        this.addSlot((Slot)new SlotChocoboSaddle((IItemHandler)chocobo.saddleItemStackHandler, 0, -16, 18));
        for (row = 0; row < 5; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)chocobo.inventory, row * 9 + col, 8 + col * 18, 18 + row * 18){

                    public boolean isActive() {
                        Item item;
                        ItemStack saddleStack = chocobo.getSaddle();
                        if (saddleStack.isEmpty()) {
                            return false;
                        }
                        if (!saddleStack.isEmpty() && (item = saddleStack.getItem()) instanceof ChocoboSaddleItem) {
                            ChocoboSaddleItem saddleItem = (ChocoboSaddleItem)item;
                            switch (saddleItem.getInventorySize()) {
                                default: {
                                    return false;
                                }
                                case 18: {
                                    int index = this.getSlotIndex();
                                    return index > 10 && index < 16 || index > 19 && index < 25 || index > 28 && index < 34;
                                }
                                case 45: 
                            }
                            return super.isActive();
                        }
                        return super.isActive();
                    }

                    public boolean mayPlace(ItemStack itemStack) {
                        return super.mayPlace(itemStack) && this.isActive();
                    }
                });
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)inventory, col + row * 9 + 9, 8 + col * 18, 122 + row * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 180));
        }
    }

    public boolean stillValid(Player playerIn) {
        return this.forgeChocobo.isAlive() && this.forgeChocobo.distanceTo((Entity)playerIn) < 8.0f;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < this.forgeChocobo.inventory.getSlots() ? !this.moveItemStackTo(itemstack1, this.forgeChocobo.inventory.getSlots(), this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.forgeChocobo.inventory.getSlots(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }
}

