/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.chestypets.network;

import net.mcreator.chestypets.ChestypetsMod;
import net.mcreator.chestypets.procedures.OpenInventoryOnKeyPressedProcedure;
import net.mcreator.chestypets.procedures.OpenInventoryOnKeyReleasedProcedure;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record OpenInventoryMessage(int eventType, int pressedms) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenInventoryMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"chestypets", (String)"key_open_inventory"));
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenInventoryMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.eventType);
        buffer.writeInt(message.pressedms);
    }, buffer -> new OpenInventoryMessage(buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<OpenInventoryMessage> type() {
        return TYPE;
    }

    public static void handleData(OpenInventoryMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> OpenInventoryMessage.pressAction(context.player(), message.eventType, message.pressedms)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!world.hasChunkAt(entity.blockPosition())) {
            return;
        }
        if (type == 0) {
            OpenInventoryOnKeyPressedProcedure.execute((LevelAccessor)world);
        }
        if (type == 1) {
            OpenInventoryOnKeyReleasedProcedure.execute((LevelAccessor)world);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ChestypetsMod.addNetworkMessage(TYPE, STREAM_CODEC, OpenInventoryMessage::handleData);
    }
}

