/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.errorprone.annotations.Keep;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public final class TickScheduler {
    private static final Queue<Token> toTick = new ConcurrentLinkedDeque<Token>();
    private static final Map<ChunkReference, List<Token>> delayed = new HashMap<ChunkReference, List<Token>>();

    private TickScheduler() {
    }

    public static void schedule(Token token) {
        Level world = token.owner.getLevel();
        if (world != null && !world.isClientSide && Token.STATE.compareAndSet(token, State.IDLE, State.SCHEDULED)) {
            toTick.add(token);
        }
    }

    public static void onChunkTicketChanged(ServerLevel level, long chunkPos, int oldLevel, int newLevel) {
        boolean oldLoaded = TickScheduler.isLoaded(oldLevel);
        boolean newLoaded = TickScheduler.isLoaded(newLevel);
        if (!oldLoaded && newLoaded) {
            List<Token> delayedTokens = delayed.remove(new ChunkReference((ResourceKey<Level>)level.dimension(), chunkPos));
            if (delayedTokens == null) {
                return;
            }
            for (Token token : delayedTokens) {
                if (token.owner.isRemoved()) {
                    Token.STATE.set(token, State.IDLE);
                    continue;
                }
                Token.STATE.set(token, State.SCHEDULED);
                toTick.add(token);
            }
        }
    }

    public static void onChunkUnload(LevelChunk chunk) {
        List<Token> delayedTokens = delayed.remove(new ChunkReference((ResourceKey<Level>)chunk.getLevel().dimension(), chunk.getPos().toLong()));
        if (delayedTokens == null) {
            return;
        }
        for (Token token : delayedTokens) {
            Token.STATE.set(token, State.IDLE);
        }
    }

    public static void tick() {
        Token token;
        while ((token = toTick.poll()) != null) {
            Token.STATE.set(token, TickScheduler.tickToken(token));
        }
    }

    private static State tickToken(Token token) {
        BlockPos pos;
        BlockEntity blockEntity = token.owner;
        if (blockEntity.isRemoved()) {
            return State.IDLE;
        }
        Level level = Objects.requireNonNull(blockEntity.getLevel(), "Block entity level cannot become null");
        if (!level.isLoaded(pos = blockEntity.getBlockPos())) {
            delayed.computeIfAbsent(new ChunkReference((ResourceKey<Level>)level.dimension(), ChunkPos.asLong((BlockPos)pos)), x -> new ArrayList()).add(token);
            return State.UNLOADED;
        }
        BlockEntity currentBlockEntity = level.getBlockEntity(pos);
        if (currentBlockEntity != blockEntity) {
            throw new IllegalStateException("Expected " + String.valueOf(blockEntity) + " at " + String.valueOf(pos) + ", got " + String.valueOf(currentBlockEntity));
        }
        level.scheduleTick(pos, blockEntity.getBlockState().getBlock(), 0);
        return State.IDLE;
    }

    private static boolean isLoaded(int level) {
        return level <= ChunkLevel.byStatus((ChunkStatus)ChunkStatus.FULL);
    }

    public static class Token {
        static final AtomicReferenceFieldUpdater<Token, State> STATE = AtomicReferenceFieldUpdater.newUpdater(Token.class, State.class, "$state");
        final BlockEntity owner;
        @Keep
        private volatile State $state = State.IDLE;

        public Token(BlockEntity owner) {
            this.owner = owner;
        }
    }

    private static enum State {
        IDLE,
        SCHEDULED,
        UNLOADED;

    }

    private record ChunkReference(ResourceKey<Level> level, Long position) {
        @Override
        public String toString() {
            return "ChunkReference(" + String.valueOf(this.level) + " at " + String.valueOf(new ChunkPos(this.position.longValue())) + ")";
        }
    }
}

