/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jspecify.annotations.Nullable;

public record StorageCapacity(long capacity) {
    public static final Codec<StorageCapacity> CODEC = Codec.LONG.validate(x -> x > 0L ? DataResult.success((Object)x) : DataResult.error(() -> "Capacity must be positive: " + x)).xmap(StorageCapacity::new, StorageCapacity::capacity);
    public static final StreamCodec<ByteBuf, StorageCapacity> STREAM_CODEC = ByteBufCodecs.VAR_LONG.map(StorageCapacity::new, StorageCapacity::capacity);

    public StorageCapacity {
        if (capacity <= 0L) {
            throw new IllegalArgumentException("Capacity must be > 0");
        }
    }

    public static long getOrDefault(@Nullable StorageCapacity capacity, Supplier<Integer> fallback) {
        return capacity == null ? (long)fallback.get().intValue() : capacity.capacity();
    }

    public static long getOrDefault(@Nullable StorageCapacity capacity, long fallback) {
        return capacity == null ? fallback : capacity.capacity();
    }
}

