/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import com.google.common.base.Strings;
import dan200.computercraft.shared.media.PrintoutMenu;
import dan200.computercraft.shared.media.items.PrintoutData;
import java.util.List;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class PrintoutItem
extends Item {
    private final Type type;

    public PrintoutItem(Item.Properties settings, Type type) {
        super(settings);
        this.type = type;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag options) {
        String title = PrintoutData.getOrEmpty((DataComponentHolder)stack).title();
        if (!title.isEmpty()) {
            list.add((Component)Component.literal((String)title));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            String title = PrintoutData.getOrEmpty((DataComponentHolder)stack).title();
            Component displayTitle = Strings.isNullOrEmpty((String)title) ? stack.getDisplayName() : Component.literal((String)title);
            player.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInventory, p) -> PrintoutMenu.createInHand(id, p, hand), displayTitle));
        }
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)world.isClientSide), (Object)stack);
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        PAGE,
        PAGES,
        BOOK;

    }
}

