/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.upload;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUpload {
    private static final Logger LOG = LoggerFactory.getLogger(FileUpload.class);
    public static final int CHECKSUM_LENGTH = 32;
    private final String name;
    private final int length;
    private final ByteBuffer bytes;
    private final byte[] checksum;

    public FileUpload(String name, ByteBuffer bytes, byte[] checksum) {
        this.name = name;
        this.bytes = bytes;
        this.length = bytes.remaining();
        this.checksum = checksum;
    }

    public String getName() {
        return this.name;
    }

    public ByteBuffer getBytes() {
        return this.bytes;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getChecksum() {
        return this.checksum;
    }

    public boolean checksumMatches() {
        byte[] digest = FileUpload.getDigest(this.bytes);
        return digest != null && Arrays.equals(this.checksum, digest);
    }

    public static byte @Nullable [] getDigest(ByteBuffer bytes) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(bytes.duplicate());
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Failed to compute digest ({})", (Object)e.toString());
            return null;
        }
    }
}

