/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.common.IBundledRedstoneBlock;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlockEntity;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.platform.RegistryEntry;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jspecify.annotations.Nullable;

public abstract class AbstractComputerBlock<T extends AbstractComputerBlockEntity>
extends HorizontalDirectionalBlock
implements IBundledRedstoneBlock,
EntityBlock {
    protected final RegistryEntry<BlockEntityType<T>> type;
    private final BlockEntityTicker<T> serverTicker = (level, pos, state, computer) -> computer.serverTick();

    protected AbstractComputerBlock(BlockBehaviour.Properties settings, RegistryEntry<BlockEntityType<T>> type) {
        super(settings);
        this.type = type;
    }

    protected void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, world, pos, oldState, isMoving);
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof AbstractComputerBlockEntity) {
            AbstractComputerBlockEntity computer = (AbstractComputerBlockEntity)tile;
            computer.updateInputsImmediately();
        }
    }

    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    protected int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction incomingSide) {
        BlockEntity entity = world.getBlockEntity(pos);
        if (!(entity instanceof AbstractComputerBlockEntity)) {
            return 0;
        }
        AbstractComputerBlockEntity computerEntity = (AbstractComputerBlockEntity)entity;
        ServerComputer computer = computerEntity.getServerComputer();
        if (computer == null) {
            return 0;
        }
        ComputerSide localSide = computerEntity.remapToLocalSide(incomingSide.getOpposite());
        return computer.getRedstoneOutput(localSide);
    }

    private ItemStack getItem(AbstractComputerBlockEntity tile) {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.applyComponents(tile.collectComponents());
        return stack;
    }

    protected int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction incomingSide) {
        return this.getDirectSignal(state, world, pos, incomingSide);
    }

    @Override
    public int getBundledRedstoneOutput(Level world, BlockPos pos, Direction side) {
        BlockEntity entity = world.getBlockEntity(pos);
        if (!(entity instanceof AbstractComputerBlockEntity)) {
            return 0;
        }
        AbstractComputerBlockEntity computerEntity = (AbstractComputerBlockEntity)entity;
        ServerComputer computer = computerEntity.getServerComputer();
        if (computer == null) {
            return 0;
        }
        ComputerSide localSide = computerEntity.remapToLocalSide(side);
        return computer.getBundledRedstoneOutput(localSide);
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        AbstractComputerBlockEntity computer;
        ItemStack result;
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof AbstractComputerBlockEntity && !(result = this.getItem(computer = (AbstractComputerBlockEntity)tile)).isEmpty()) {
            return result;
        }
        return super.getCloneItemStack(world, pos, state);
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity tile, ItemStack tool) {
        super.playerDestroy(world, player, pos, Blocks.AIR.defaultBlockState(), tile, tool);
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        Block.dropResources((BlockState)state, (Level)world, (BlockPos)pos, (BlockEntity)world.getBlockEntity(pos), (Entity)player, (ItemStack)player.getMainHandItem());
        return super.playerWillDestroy(world, pos, state, player);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!player.isCrouching() && (blockEntity = level.getBlockEntity(pos)) instanceof AbstractComputerBlockEntity) {
            AbstractComputerBlockEntity computer = (AbstractComputerBlockEntity)blockEntity;
            if (!level.isClientSide && computer.isUsable(player)) {
                ServerComputer serverComputer = computer.createServerComputer();
                serverComputer.turnOn();
                PlatformHelper.get().openMenu(player, computer.getName(), computer, new ComputerContainerData(serverComputer, this.getItem(computer)));
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }

    protected final void neighborChanged(BlockState state, Level world, BlockPos pos, Block neighbourBlock, BlockPos neighbourPos, boolean isMoving) {
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof AbstractComputerBlockEntity) {
            AbstractComputerBlockEntity computer = (AbstractComputerBlockEntity)be;
            computer.neighborChanged(neighbourPos);
        }
    }

    public final void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbour) {
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof AbstractComputerBlockEntity) {
            AbstractComputerBlockEntity computer = (AbstractComputerBlockEntity)be;
            computer.neighborChanged(neighbour);
        }
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof AbstractComputerBlockEntity) {
            AbstractComputerBlockEntity computer = (AbstractComputerBlockEntity)be;
            computer.neighbourShapeChanged(direction);
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public <U extends BlockEntity> @Nullable BlockEntityTicker<U> getTicker(Level level, BlockState state, BlockEntityType<U> type) {
        return level.isClientSide ? null : BlockEntityHelpers.createTickerHelper(type, (BlockEntityType)this.type.get(), this.serverTicker);
    }

    public @Nullable BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)this.type.get()).create(pos, state);
    }
}

