/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.api.upgrades.UpgradeType;
import dan200.computercraft.shared.util.SafeDispatchCodec;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public final class UpgradeManager<T extends UpgradeBase> {
    private final ResourceKey<Registry<T>> registry;
    private final Codec<T> upgradeCodec;
    private final Codec<UpgradeData<T>> dataCodec;
    private final StreamCodec<RegistryFriendlyByteBuf, UpgradeData<T>> dataStreamCodec;

    UpgradeManager(ResourceKey<Registry<UpgradeType<? extends T>>> typeRegistry, ResourceKey<Registry<T>> registry, Function<T, UpgradeType<? extends T>> getType) {
        this.registry = registry;
        this.upgradeCodec = SafeDispatchCodec.ofRegistry(typeRegistry, getType, UpgradeType::codec);
        Codec holderCodec = RegistryFixedCodec.create(registry).xmap(x -> (Holder.Reference)x, x -> x);
        Codec fullCodec = RecordCodecBuilder.create(i -> i.group((App)holderCodec.fieldOf("id").forGetter(UpgradeData::holder), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(UpgradeData::data)).apply((Applicative)i, UpgradeData::new));
        this.dataCodec = Codec.withAlternative((Codec)fullCodec, (Codec)holderCodec, UpgradeData::ofDefault);
        this.dataStreamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry(registry).map(x -> (Holder.Reference)x, x -> x), UpgradeData::holder, (StreamCodec)DataComponentPatch.STREAM_CODEC, UpgradeData::data, UpgradeData::new);
    }

    public Codec<T> upgradeCodec() {
        return this.upgradeCodec;
    }

    public Codec<UpgradeData<T>> upgradeDataCodec() {
        return this.dataCodec;
    }

    public StreamCodec<RegistryFriendlyByteBuf, UpgradeData<T>> upgradeDataStreamCodec() {
        return this.dataStreamCodec;
    }

    public String getOwner(Holder.Reference<T> upgrade) {
        String ns = upgrade.key().location().getNamespace();
        return ns.equals("minecraft") ? "computercraft" : ns;
    }

    public @Nullable UpgradeData<T> get(HolderLookup.Provider registries, ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        return registries.lookupOrThrow(this.registry).listElements().filter(holder -> {
            UpgradeBase upgrade = (UpgradeBase)holder.value();
            ItemStack craftingStack = upgrade.getCraftingItem();
            return !craftingStack.isEmpty() && craftingStack.getItem() == stack.getItem() && upgrade.isItemSuitable(stack);
        }).findAny().map(x -> UpgradeData.of(x, ((UpgradeBase)x.value()).getUpgradeData(stack))).orElse(null);
    }
}

