/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http.websocket;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.http.HTTPRequestException;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;

public interface WebsocketClient
extends Closeable {
    public static final String SUCCESS_EVENT = "websocket_success";
    public static final String FAILURE_EVENT = "websocket_failure";
    public static final String CLOSE_EVENT = "websocket_closed";
    public static final String MESSAGE_EVENT = "websocket_message";

    public boolean isClosed();

    @Override
    public void close();

    public void sendText(String var1) throws LuaException;

    public void sendBinary(ByteBuffer var1) throws LuaException;

    public static URI parseUri(String address) throws HTTPRequestException {
        URI uri = null;
        try {
            uri = new URI(address);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (uri == null || uri.getHost() == null) {
            try {
                uri = new URI("ws://" + address);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (uri == null || uri.getHost() == null) {
            throw new HTTPRequestException("URL malformed");
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            try {
                uri = new URI("ws://" + String.valueOf(uri));
            }
            catch (URISyntaxException e) {
                throw new HTTPRequestException("URL malformed");
            }
        } else if (!scheme.equalsIgnoreCase("wss") && !scheme.equalsIgnoreCase("ws")) {
            throw new HTTPRequestException("Invalid scheme '" + scheme + "'");
        }
        return uri;
    }
}

