/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import dan200.computercraft.client.gui.GuiSprites;
import dan200.computercraft.client.render.monitor.MonitorTextureBufferShader;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import java.io.IOException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.jspecify.annotations.Nullable;

public class RenderTypes {
    public static final int FULL_BRIGHT_LIGHTMAP = 0xF000F0;
    private static @Nullable MonitorTextureBufferShader monitorTboShader;
    public static final RenderType TERMINAL;
    public static final RenderType MONITOR_TBO;
    public static final RenderType PRINTOUT_TEXT;
    public static final RenderType PRINTOUT_BACKGROUND;
    public static final RenderType GUI_SPRITES;

    public static MonitorTextureBufferShader getMonitorTextureBufferShader() {
        if (monitorTboShader == null) {
            throw new NullPointerException("MonitorTboShader has not been registered");
        }
        return monitorTboShader;
    }

    public static ShaderInstance getTerminalShader() {
        return Objects.requireNonNull(GameRenderer.getRendertypeTextShader(), "Text shader has not been registered");
    }

    public static void registerShaders(ResourceProvider resources, BiConsumer<ShaderInstance, Consumer<ShaderInstance>> load) throws IOException {
        load.accept(new MonitorTextureBufferShader(resources, "computercraft/monitor_tbo", MONITOR_TBO.format()), x -> {
            monitorTboShader = (MonitorTextureBufferShader)((Object)x);
        });
    }

    static {
        TERMINAL = RenderType.text((ResourceLocation)FixedWidthFontRenderer.FONT);
        MONITOR_TBO = Types.MONITOR_TBO;
        PRINTOUT_TEXT = RenderType.text((ResourceLocation)FixedWidthFontRenderer.FONT);
        PRINTOUT_BACKGROUND = RenderType.text((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"textures/gui/printout.png"));
        GUI_SPRITES = RenderType.text((ResourceLocation)GuiSprites.TEXTURE);
    }

    private static final class Types
    extends RenderType {
        private static final RenderStateShard.TextureStateShard TERM_FONT_TEXTURE = new RenderStateShard.TextureStateShard(FixedWidthFontRenderer.FONT, false, false);
        static final RenderType MONITOR_TBO = RenderType.create((String)"monitor_tbo", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_STRIP, (int)128, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)TERM_FONT_TEXTURE).setShaderState(new RenderStateShard.ShaderStateShard(RenderTypes::getMonitorTextureBufferShader)).createCompositeState(false));

        private Types(String name, VertexFormat format, VertexFormat.Mode mode, int buffer, boolean crumbling, boolean sort, Runnable setup, Runnable teardown) {
            super(name, format, mode, buffer, crumbling, sort, setup, teardown);
        }
    }
}

