/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.fire;

import com.github.L_Ender.cataclysm.entity.effect.Flame_Strike_Entity;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import java.util.Optional;
import net.acetheeldritchking.cataclysm_spellbooks.spells.fire.AbstractIgnisSpell;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

@AutoSpellConfig
public class IncinerationSpell
extends AbstractIgnisSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"incineration");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(5).setCooldownSeconds(40.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.cataclysm_spellbooks.range", (Object[])new Object[]{Utils.stringTruncation((double)spellLevel, (int)2)}), Component.translatable((String)"ui.cataclysm_spellbooks.incineration_duration", (Object[])new Object[]{Utils.stringTruncation((double)(this.spellPower(spellLevel, caster) / 10.0f), (int)2)}));
    }

    public IncinerationSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 5;
        this.castTime = 30;
        this.baseManaCost = 120;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)ModSounds.IGNIS_AMBIENT.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)ModSounds.FLAME_BURST.get());
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.CHARGE_SPIT_ANIMATION;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        float MAX_HEALTH = entity.getMaxHealth();
        float baseHealth = entity.getHealth();
        double percent = baseHealth / MAX_HEALTH * 100.0f;
        double casterX = entity.getX();
        double casterZ = entity.getZ();
        double casterHeadY = entity.getY() + 1.0;
        int standOnYPos = Mth.floor((double)entity.getY()) - 2;
        float yawRadians = (float)Math.toRadians(90.0f + entity.getYRot());
        int i = 0;
        while ((float)i < this.spellPower(spellLevel, entity) / 10.0f) {
            double d2 = 2.25 * (double)(i + 1);
            int j2 = (int)(1.5f * (float)i);
            double casterXYaw = casterX + (double)Mth.cos((float)yawRadians) * d2;
            double casterZYaw = casterZ + (double)Mth.sin((float)yawRadians) * d2;
            if (percent <= 50.0) {
                this.spawnFlameStrike(casterXYaw, casterZYaw, standOnYPos, casterHeadY, yawRadians, spellLevel * 20, j2, j2, level, 1.0f, true, entity, spellLevel);
            } else {
                this.spawnFlameStrike(casterXYaw, casterZYaw, standOnYPos, casterHeadY, yawRadians, spellLevel * 20, j2, j2, level, 1.0f, false, entity, spellLevel);
            }
            ++i;
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void spawnFlameStrike(double x, double z, double minY, double maxY, float rotation, int duration, int wait, int delay, Level level, float radius, boolean isSoul, LivingEntity caster, int spellLevel) {
        BlockPos pos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockState1;
            VoxelShape voxelShape;
            BlockPos pos1;
            BlockState blockState;
            if (!(blockState = level.getBlockState(pos1 = pos.below())).isFaceSturdy((BlockGetter)level, pos1, Direction.UP)) continue;
            if (!level.isEmptyBlock(pos) && !(voxelShape = (blockState1 = level.getBlockState(pos)).getCollisionShape((BlockGetter)level, pos)).isEmpty()) {
                d0 = voxelShape.max(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((pos = pos.below()).getY() >= Mth.floor((double)minY) - 1);
        if (flag) {
            level.addFreshEntity((Entity)new Flame_Strike_Entity(level, x, (double)pos.getY() + d0, z, rotation, duration, wait, delay, radius, this.getDamage(spellLevel, caster), this.getHPDamage(spellLevel), isSoul, caster));
            if (isSoul) {
                // empty if block
            }
            level.addFreshEntity((Entity)new Flame_Strike_Entity(level, x, (double)pos.getY() + d0, z, rotation, duration, wait, delay, radius, (float)((double)this.getDamage(spellLevel, caster) * 1.5), this.getHPDamage(spellLevel), isSoul, caster));
        }
    }

    private float spellPower(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster);
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return (float)((double)this.getSpellPower(spellLevel, (Entity)caster) / 1.5);
    }

    private float getHPDamage(int spellLevel) {
        return (float)(spellLevel * 10) / 100.0f;
    }
}

