/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.abyssal;

import com.github.L_Ender.cataclysm.Attachment.TidalTentacleAttachment;
import com.github.L_Ender.cataclysm.entity.projectile.Tidal_Tentacle_Entity;
import com.github.L_Ender.cataclysm.entity.util.TidalTentacleUtil;
import com.github.L_Ender.cataclysm.init.ModDataAttachments;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.spells.abyssal.AbstractAbyssalSpell;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

@AutoSpellConfig
public class TidalGrabSpell
extends AbstractAbyssalSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"tidal_grab");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(CSSchoolRegistry.ABYSSAL_RESOURCE).setMaxLevel(5).setCooldownSeconds(50.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.cataclysm_spellbooks.range", (Object[])new Object[]{Utils.stringTruncation((double)(this.getRange(spellLevel, caster) / 10.0f), (int)2)}));
    }

    public TidalGrabSpell() {
        this.manaCostPerLevel = 1;
        this.baseSpellPower = 0;
        this.spellPowerPerLevel = 5;
        this.castTime = 100;
        this.baseManaCost = 10;
    }

    public boolean canBeCraftedBy(Player player) {
        Item tidalClaws = (Item)ModItems.TIDAL_CLAWS.get();
        return player.getMainHandItem().is(tidalClaws);
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.CONTINUOUS;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)ModSounds.TIDAL_TENTACLE.get());
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        return Utils.preCastTargetHelper((Level)level, (LivingEntity)entity, (MagicData)playerMagicData, (AbstractSpell)this, (int)((int)this.getRange(spellLevel, entity) / 10), (float)0.15f);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        TargetEntityCastData targetEntityCastData;
        LivingEntity targetEntity;
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData && (targetEntity = (targetEntityCastData = (TargetEntityCastData)iCastData).getTarget((ServerLevel)level)) != null) {
            Entity validTarget = null;
            HitResult hitResult = Utils.raycastForEntity((Level)level, (Entity)entity, (float)(this.getRange(spellLevel, entity) / 10.0f), (boolean)true, (float)0.25f);
            if (hitResult.getType() == HitResult.Type.ENTITY) {
                Entity target = ((EntityHitResult)hitResult).getEntity();
                if (target.equals((Object)entity) || entity.isAlliedTo(target) || target.isAlliedTo((Entity)entity) || !(target instanceof Mob) || !entity.hasLineOfSight(target)) {
                    Iterator iterator = level.getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(10.0)).iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            this.launchTentacle(entity, (LivingEntity)validTarget, level);
                            return;
                        }
                        Entity e = (Entity)iterator.next();
                        if (e.equals((Object)entity) || entity.isAlliedTo(e) || e.isAlliedTo((Entity)entity) || !(e instanceof Mob) || !entity.hasLineOfSight(e) || validTarget != null && !(entity.distanceTo(e) < entity.distanceTo(validTarget))) continue;
                        validTarget = e;
                    }
                }
                validTarget = target;
                this.launchTentacle(entity, (LivingEntity)validTarget, level);
            }
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void launchTentacle(LivingEntity caster, LivingEntity target, Level level) {
        TidalTentacleAttachment attachment = (TidalTentacleAttachment)caster.getData((Supplier)ModDataAttachments.TIDAL_TENTACLE_ATTACHMENT);
        if (!attachment.hasTentacle() && TidalTentacleUtil.canLaunchTentacles((Level)level, (LivingEntity)caster) && !level.isClientSide && target != null) {
            Tidal_Tentacle_Entity tentacle = (Tidal_Tentacle_Entity)((EntityType)ModEntities.TIDAL_TENTACLE.get()).create(level);
            assert (tentacle != null);
            tentacle.copyPosition((Entity)caster);
            level.addFreshEntity((Entity)tentacle);
            tentacle.setCreatorEntityUUID(caster.getUUID());
            tentacle.setFromEntityID(caster.getId());
            tentacle.setToEntityID(target.getId());
            tentacle.copyPosition((Entity)caster);
            tentacle.setProgress(0.0f);
            TidalTentacleUtil.setLastTentacle((LivingEntity)caster, (Tidal_Tentacle_Entity)tentacle);
        }
    }

    private float getRange(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * (float)(2 * spellLevel);
    }
}

