/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class AddItemModifier
extends LootModifier {
    public static final Supplier<MapCodec<AddItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> AddItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.STRING.fieldOf("loot_table").forGetter(m -> m.lootTable)).apply((Applicative)inst, AddItemModifier::new)));
    private final String lootTable;

    protected AddItemModifier(LootItemCondition[] conditionsIn, String item) {
        super(conditionsIn);
        this.lootTable = item;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext lootContext) {
        ResourceLocation resourcePath = ResourceLocation.parse((String)this.lootTable);
        LootTable addedLootTable = lootContext.getLevel().getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)resourcePath));
        ObjectArrayList items = new ObjectArrayList();
        addedLootTable.getRandomItemsRaw(lootContext, arg_0 -> ((ObjectArrayList)items).add(arg_0));
        generatedLoot.addAll((ObjectList)items);
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

