/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.config.neoforge;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import tschipp.carryon.config.AnnotationData;
import tschipp.carryon.config.BuiltCategory;
import tschipp.carryon.config.BuiltConfig;
import tschipp.carryon.config.PropertyData;

@EventBusSubscriber(modid="carryon", bus=EventBusSubscriber.Bus.MOD)
public class ConfigLoaderImpl {
    public static final Map<ModConfigSpec, BuiltConfig> CONFIGS = new HashMap<ModConfigSpec, BuiltConfig>();

    public static void initialize(ModContainer container) {
        CONFIGS.forEach((spec, config) -> {
            if (config.fileName.contains("client")) {
                container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)spec, config.fileName + ".toml");
            } else {
                container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)spec, config.fileName + ".toml");
            }
        });
    }

    @SubscribeEvent
    public static void onConfigLoad(ModConfigEvent.Loading loading) {
        ConfigLoaderImpl.loadConfig((ModConfigSpec)loading.getConfig().getSpec());
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent.Reloading loading) {
        ConfigLoaderImpl.loadConfig((ModConfigSpec)loading.getConfig().getSpec());
    }

    private static void loadConfig(ModConfigSpec spec) {
        BuiltConfig builtConfig = CONFIGS.get(spec);
        if (builtConfig == null) {
            return;
        }
        ConfigLoaderImpl.loadConfig(builtConfig, spec.getValues());
    }

    private static void loadConfig(BuiltCategory category, UnmodifiableConfig config) {
        config.valueMap().forEach((id, value) -> {
            if (value instanceof ModConfigSpec.ConfigValue) {
                ModConfigSpec.ConfigValue configValue = (ModConfigSpec.ConfigValue)value;
                category.getProperty((String)id).ifPresent(data -> {
                    Object patt0$temp;
                    if (configValue instanceof ModConfigSpec.BooleanValue) {
                        ModConfigSpec.BooleanValue booleanValue = (ModConfigSpec.BooleanValue)configValue;
                        data.setBoolean((Boolean)booleanValue.get());
                    }
                    if (configValue instanceof ModConfigSpec.IntValue) {
                        ModConfigSpec.IntValue intValue = (ModConfigSpec.IntValue)configValue;
                        data.setInt((Integer)intValue.get());
                    }
                    if (configValue instanceof ModConfigSpec.DoubleValue) {
                        ModConfigSpec.DoubleValue doubleValue = (ModConfigSpec.DoubleValue)configValue;
                        data.setDouble((Double)doubleValue.get());
                    }
                    if ((patt0$temp = configValue.get()) instanceof List) {
                        List listVal = (List)patt0$temp;
                        data.setStringArray(listVal.toArray(new String[listVal.size()]));
                    }
                });
            } else if (value instanceof AbstractConfig) {
                AbstractConfig subConfig = (AbstractConfig)value;
                category.getCategory((String)id).ifPresent(cat -> ConfigLoaderImpl.loadConfig(cat, (UnmodifiableConfig)subConfig));
            }
        });
    }

    public static void registerConfig(BuiltConfig config) {
        try {
            ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
            for (PropertyData property : config.properties) {
                ConfigLoaderImpl.buildProperty(builder, property);
            }
            for (BuiltCategory category : config.categories) {
                ConfigLoaderImpl.buildCategory(builder, category);
            }
            CONFIGS.put(builder.build(), config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void buildCategory(ModConfigSpec.Builder builder, BuiltCategory category) throws IllegalAccessException {
        builder.push(category.category);
        if (category.categoryDesc != null) {
            builder.comment(category.categoryDesc);
        }
        for (PropertyData property : category.properties) {
            ConfigLoaderImpl.buildProperty(builder, property);
        }
        for (BuiltCategory builtCategory : category.categories) {
            ConfigLoaderImpl.buildCategory(builder, builtCategory);
        }
        builder.pop();
    }

    private static void buildProperty(ModConfigSpec.Builder builder, PropertyData data) throws IllegalAccessException {
        AnnotationData annotationData = data.data();
        builder.comment(annotationData.description());
        switch (annotationData.type()) {
            case BOOLEAN: {
                builder.define(data.getId(), data.getBoolean());
                break;
            }
            case INT: {
                builder.defineInRange(data.getId(), data.getInt(), annotationData.min(), annotationData.max());
                break;
            }
            case DOUBLE: {
                builder.defineInRange(data.getId(), data.getDouble(), annotationData.minD(), annotationData.maxD());
                break;
            }
            case STRING_ARRAY: {
                builder.defineListAllowEmpty(List.of(data.getId()), () -> {
                    try {
                        return Arrays.asList(data.getStringArray());
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        return new ArrayList();
                    }
                }, obj -> obj instanceof String);
                break;
            }
            default: {
                throw new IllegalAccessException("Unknown property type.");
            }
        }
    }
}

