/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import tschipp.carryon.Constants;
import tschipp.carryon.client.render.CarryRenderHelper;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.scripting.CarryOnScript;
import tschipp.carryon.platform.Services;

public class CarriedObjectRender {
    private static SequencedMap<RenderType, ByteBufferBuilder> builders = new LinkedHashMap<RenderType, ByteBufferBuilder>(Map.of(RenderType.glint(), new ByteBufferBuilder(RenderType.glint().bufferSize()), RenderType.armorEntityGlint(), new ByteBufferBuilder(RenderType.armorEntityGlint().bufferSize()), RenderType.glintTranslucent(), new ByteBufferBuilder(RenderType.glintTranslucent().bufferSize()), RenderType.entityGlint(), new ByteBufferBuilder(RenderType.entityGlint().bufferSize()), RenderType.entityGlintDirect(), new ByteBufferBuilder(RenderType.entityGlintDirect().bufferSize())));

    public static boolean drawFirstPerson(Player player, MultiBufferSource buffer, PoseStack matrix, int light, float partialTicks) {
        if (Services.PLATFORM.isModLoaded("firstperson") || Services.PLATFORM.isModLoaded("firstpersonmod")) {
            return false;
        }
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        try {
            if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
                CarriedObjectRender.drawFirstPersonBlock(player, buffer, matrix, light, CarryRenderHelper.getRenderState(player));
            } else if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
                CarriedObjectRender.drawFirstPersonEntity(player, buffer, matrix, light, partialTicks);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (carry.getActiveScript().isPresent()) {
            CarryOnScript.ScriptRender render = carry.getActiveScript().get().scriptRender();
            if (!render.renderLeftArm() && player.getMainArm() == HumanoidArm.LEFT) {
                return false;
            }
            if (!render.renderRightArm() && player.getMainArm() == HumanoidArm.RIGHT) {
                return false;
            }
        }
        return carry.isCarrying();
    }

    private static void drawFirstPersonBlock(Player player, MultiBufferSource buffer, PoseStack matrix, int light, BlockState state) {
        matrix.pushPose();
        matrix.scale(2.5f, 2.5f, 2.5f);
        matrix.translate(0.0, -0.5, -1.0);
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (Constants.CLIENT_CONFIG.facePlayer != CarryRenderHelper.isChest(state.getBlock())) {
            matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
            matrix.mulPose(Axis.XN.rotationDegrees(8.0f));
        } else {
            matrix.mulPose(Axis.XP.rotationDegrees(8.0f));
        }
        if (carry.getActiveScript().isPresent()) {
            CarryRenderHelper.performScriptTransformation(matrix, carry.getActiveScript().get());
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        ItemStack stack = new ItemStack((ItemLike)state.getBlock().asItem());
        BakedModel model = CarryRenderHelper.getRenderBlock(player);
        CarryRenderHelper.renderBakedModel(stack, matrix, buffer, light, model);
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        matrix.popPose();
    }

    private static void drawFirstPersonEntity(Player player, MultiBufferSource buffer, PoseStack matrix, int light, float partialTicks) {
        EntityRenderDispatcher manager = Minecraft.getInstance().getEntityRenderDispatcher();
        Entity entity = CarryRenderHelper.getRenderEntity(player);
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (entity != null) {
            Vec3 playerpos = CarryRenderHelper.getExactPos((Entity)player, partialTicks);
            entity.setPos(playerpos.x, playerpos.y, playerpos.z);
            entity.xRotO = 0.0f;
            entity.yRotO = 0.0f;
            entity.setYHeadRot(0.0f);
            float height = entity.getBbHeight();
            float width = entity.getBbWidth();
            matrix.pushPose();
            matrix.scale(0.8f, 0.8f, 0.8f);
            matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
            matrix.translate(0.0, (double)(-height) - 0.1, (double)width + 0.1);
            manager.setRenderShadow(false);
            Optional<CarryOnScript> res = carry.getActiveScript();
            if (res.isPresent()) {
                CarryOnScript script = res.get();
                CarryRenderHelper.performScriptTransformation(matrix, script);
            }
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).hurtTime = 0;
            }
            try {
                manager.render(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrix, buffer, light);
            }
            catch (Exception exception) {
                // empty catch block
            }
            manager.setRenderShadow(true);
            matrix.popPose();
        }
    }

    public static void drawThirdPerson(float partialticks, Matrix4f mat) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        int light = 0;
        int perspective = CarryRenderHelper.getPerspective();
        EntityRenderDispatcher manager = mc.getEntityRenderDispatcher();
        PoseStack matrix = new PoseStack();
        matrix.mulPose(mat);
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.disableDepthTest();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.immediateWithBuffers(builders, (ByteBufferBuilder)((ByteBufferBuilder)builders.get(RenderType.glint())));
        for (Player player : level.players()) {
            try {
                Entity entity;
                CarryOnData carry = CarryOnDataManager.getCarryData(player);
                if (perspective == 0 && player == mc.player && !Services.PLATFORM.isModLoaded("firstperson") && !Services.PLATFORM.isModLoaded("firstpersonmod") && !Services.PLATFORM.isModLoaded("realcamera")) continue;
                light = manager.getPackedLightCoords((Entity)player, partialticks);
                if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
                    BlockState state = CarryRenderHelper.getRenderState(player);
                    CarryRenderHelper.applyBlockTransformations(player, partialticks, matrix, state.getBlock());
                    ItemStack tileItem = new ItemStack((ItemLike)state.getBlock().asItem());
                    BakedModel model = CarryRenderHelper.getRenderBlock(player);
                    Optional<CarryOnScript> res = carry.getActiveScript();
                    if (res.isPresent()) {
                        CarryOnScript script = res.get();
                        CarryRenderHelper.performScriptTransformation(matrix, script);
                    }
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
                    RenderSystem.enableCull();
                    PoseStack.Pose p = matrix.last();
                    PoseStack copy = new PoseStack();
                    copy.mulPose(p.pose());
                    matrix.popPose();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    CarryRenderHelper.renderBakedModel(tileItem, copy, (MultiBufferSource)buffer, light, model);
                    matrix.popPose();
                    continue;
                }
                if (!carry.isCarrying(CarryOnData.CarryType.ENTITY) || (entity = CarryRenderHelper.getRenderEntity(player)) == null) continue;
                CarryRenderHelper.applyEntityTransformations(player, partialticks, matrix, entity);
                manager.setRenderShadow(false);
                Optional<CarryOnScript> res = carry.getActiveScript();
                if (res.isPresent()) {
                    CarryOnScript script = res.get();
                    CarryRenderHelper.performScriptTransformation(matrix, script);
                }
                if (entity instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)entity;
                    le.hurtTime = 0;
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                manager.render(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrix, (MultiBufferSource)buffer, light);
                matrix.popPose();
                manager.setRenderShadow(true);
                matrix.popPose();
            }
            catch (Exception exception) {}
        }
        buffer.endLastBatch();
        buffer.endBatch(RenderType.entitySolid((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
        buffer.endBatch(RenderType.entityCutout((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
        buffer.endBatch(RenderType.entityCutoutNoCull((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
        buffer.endBatch(RenderType.entitySmoothCutout((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }
}

