/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.neoforge.datagen.recipe;

import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.TieredAutocrafterBlock;
import com.ultramega.cabletiers.common.constructordestructor.TieredConstructorBlock;
import com.ultramega.cabletiers.common.constructordestructor.TieredDestructorBlock;
import com.ultramega.cabletiers.common.exporter.TieredExporterBlock;
import com.ultramega.cabletiers.common.importer.TieredImporterBlock;
import com.ultramega.cabletiers.common.registry.Blocks;
import com.ultramega.cabletiers.common.storage.diskinterface.TieredDiskInterfaceBlock;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class RecoloringRecipeProvider
extends RecipeProvider {
    public RecoloringRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput output) {
        for (CableTiers tier : CableTiers.values()) {
            Blocks.INSTANCE.getTieredImporters(tier).forEach((color, id, block) -> this.recipe(tier.getItemTag(CableType.IMPORTER), ((TieredImporterBlock)((Object)((Object)block.get()))).asItem(), color).save(output, this.recipeId(color, tier.toString().toLowerCase() + "_importer")));
            Blocks.INSTANCE.getTieredExporters(tier).forEach((color, id, block) -> this.recipe(tier.getItemTag(CableType.EXPORTER), ((TieredExporterBlock)((Object)((Object)block.get()))).asItem(), color).save(output, this.recipeId(color, tier.toString().toLowerCase() + "_exporter")));
            Blocks.INSTANCE.getTieredDestructors(tier).forEach((color, id, block) -> this.recipe(tier.getItemTag(CableType.DESTRUCTOR), ((TieredDestructorBlock)((Object)((Object)block.get()))).asItem(), color).save(output, this.recipeId(color, tier.toString().toLowerCase() + "_destructor")));
            Blocks.INSTANCE.getTieredConstructors(tier).forEach((color, id, block) -> this.recipe(tier.getItemTag(CableType.CONSTRUCTOR), ((TieredConstructorBlock)((Object)((Object)block.get()))).asItem(), color).save(output, this.recipeId(color, tier.toString().toLowerCase() + "_constructor")));
            Blocks.INSTANCE.getTieredDiskInterfaces(tier).forEach((color, id, block) -> this.recipe(tier.getItemTag(CableType.DISK_INTERFACE), ((TieredDiskInterfaceBlock)((Object)((Object)block.get()))).asItem(), color).save(output, this.recipeId(color, tier.toString().toLowerCase() + "_disk_interface")));
            Blocks.INSTANCE.getTieredAutocrafters(tier).forEach((color, id, block) -> this.recipe(tier.getItemTag(CableType.AUTOCRAFTER), ((TieredAutocrafterBlock)((Object)((Object)block.get()))).asItem(), color).save(output, this.recipeId(color, tier.toString().toLowerCase() + "_autocrafter")));
        }
    }

    private ResourceLocation recipeId(DyeColor color, String suffix) {
        return CableTiersIdentifierUtil.createCableTiersIdentifier("coloring/" + color.getName() + "_" + suffix);
    }

    private ShapelessRecipeBuilder recipe(TagKey<Item> dyeable, Item result, DyeColor color) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).requires(dyeable).requires(RecoloringRecipeProvider.getDyeTag(color)).unlockedBy("has_" + dyeable.location().getPath(), RecoloringRecipeProvider.has(dyeable));
    }

    private static TagKey<Item> getDyeTag(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.RED -> Tags.Items.DYES_RED;
            case DyeColor.WHITE -> Tags.Items.DYES_WHITE;
            case DyeColor.ORANGE -> Tags.Items.DYES_ORANGE;
            case DyeColor.MAGENTA -> Tags.Items.DYES_MAGENTA;
            case DyeColor.LIGHT_BLUE -> Tags.Items.DYES_LIGHT_BLUE;
            case DyeColor.YELLOW -> Tags.Items.DYES_YELLOW;
            case DyeColor.LIME -> Tags.Items.DYES_LIME;
            case DyeColor.PINK -> Tags.Items.DYES_PINK;
            case DyeColor.GRAY -> Tags.Items.DYES_GRAY;
            case DyeColor.LIGHT_GRAY -> Tags.Items.DYES_LIGHT_GRAY;
            case DyeColor.CYAN -> Tags.Items.DYES_CYAN;
            case DyeColor.PURPLE -> Tags.Items.DYES_PURPLE;
            case DyeColor.BLUE -> Tags.Items.DYES_BLUE;
            case DyeColor.BROWN -> Tags.Items.DYES_BROWN;
            case DyeColor.GREEN -> Tags.Items.DYES_GREEN;
            case DyeColor.BLACK -> Tags.Items.DYES_BLACK;
        };
    }
}

