/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.storage.diskinterface;

import com.refinedmods.refinedstorage.api.network.impl.node.storagetransfer.StorageTransferMode;
import com.refinedmods.refinedstorage.common.storage.FilterModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.FuzzyModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.RedstoneModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.storage.diskinterface.DiskInterfacePropertyTypes;
import com.ultramega.cabletiers.common.storage.diskinterface.TieredDiskInterfaceContainerMenu;
import com.ultramega.cabletiers.common.storage.diskinterface.TransferModeSideButtonWidget;
import com.ultramega.cabletiers.common.support.AbstractAdvancedFilterScreen;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class TieredDiskInterfaceScreen
extends AbstractAdvancedFilterScreen<TieredDiskInterfaceContainerMenu> {
    private static final ResourceLocation ELITE_TEXTURE = CableTiersIdentifierUtil.createCableTiersIdentifier("textures/gui/elite_disk_interface.png");
    private static final ResourceLocation ULTRA_TEXTURE = CableTiersIdentifierUtil.createCableTiersIdentifier("textures/gui/ultra_disk_interface.png");
    private static final ResourceLocation MEGA_TEXTURE = CableTiersIdentifierUtil.createCableTiersIdentifier("textures/gui/mega_disk_interface.png");
    private static final MutableComponent IN_TEXT = IdentifierUtil.createTranslation((String)"gui", (String)"disk_interface.in");
    private static final MutableComponent OUT_TEXT = IdentifierUtil.createTranslation((String)"gui", (String)"disk_interface.out");

    public TieredDiskInterfaceScreen(TieredDiskInterfaceContainerMenu menu, Inventory playerInventory, Component title, CableTiers tier) {
        super(menu, playerInventory, title, tier);
        this.inventoryLabelY = 117 + TieredDiskInterfaceContainerMenu.getYIncrease(tier);
        this.imageHeight = 211 + TieredDiskInterfaceContainerMenu.getYIncrease(tier);
    }

    protected void init() {
        super.init();
        this.addSideButton((AbstractSideButtonWidget)new RedstoneModeSideButtonWidget(((TieredDiskInterfaceContainerMenu)this.getMenu()).getProperty(PropertyTypes.REDSTONE_MODE)));
        this.addSideButton(new TransferModeSideButtonWidget((ClientProperty<StorageTransferMode>)((TieredDiskInterfaceContainerMenu)this.getMenu()).getProperty(DiskInterfacePropertyTypes.TRANSFER_MODE)));
        this.addSideButton((AbstractSideButtonWidget)new FilterModeSideButtonWidget(((TieredDiskInterfaceContainerMenu)this.getMenu()).getProperty(PropertyTypes.FILTER_MODE), (Component)IdentifierUtil.createTranslation((String)"gui", (String)"disk_interface.filter_mode.allow.help"), (Component)IdentifierUtil.createTranslation((String)"gui", (String)"disk_interface.filter_mode.block.help")));
        this.addSideButton((AbstractSideButtonWidget)new FuzzyModeSideButtonWidget(((TieredDiskInterfaceContainerMenu)this.getMenu()).getProperty(PropertyTypes.FUZZY_MODE), () -> ((TieredDiskInterfaceContainerMenu)this.getMenu()).getProperty(DiskInterfacePropertyTypes.TRANSFER_MODE).getValue() == StorageTransferMode.EXTRACT_FROM_NETWORK ? FuzzyModeSideButtonWidget.Type.EXTRACTING_STORAGE_NETWORK : FuzzyModeSideButtonWidget.Type.EXTRACTING_SOURCE));
    }

    protected void renderLabels(GuiGraphics graphics, int x, int y) {
        super.renderLabels(graphics, x, y);
        graphics.drawString(this.font, (Component)IN_TEXT, 43, 45 + TieredDiskInterfaceContainerMenu.getYIncrease(this.tier), 0x404040, false);
        graphics.drawString(this.font, (Component)OUT_TEXT, 115, 45 + TieredDiskInterfaceContainerMenu.getYIncrease(this.tier), 0x404040, false);
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        int textureSize = this.tier == CableTiers.ELITE ? 256 : 512;
        graphics.blit(this.getTexture(), x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, textureSize, textureSize);
        this.renderResourceSlots(graphics);
    }

    @Override
    protected ResourceLocation getTexture() {
        return switch (this.tier) {
            default -> throw new MatchException(null, null);
            case CableTiers.ELITE -> ELITE_TEXTURE;
            case CableTiers.ULTRA -> ULTRA_TEXTURE;
            case CableTiers.MEGA, CableTiers.CREATIVE -> MEGA_TEXTURE;
        };
    }

    protected boolean hasUpgrades() {
        return this.tier != CableTiers.CREATIVE;
    }
}

