/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.importer;

import com.refinedmods.refinedstorage.api.network.impl.node.importer.CompositeImporterTransferStrategy;
import com.refinedmods.refinedstorage.api.network.node.importer.ImporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeState;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.FilterModeSettings;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.TieredUpgradeDestinations;
import com.ultramega.cabletiers.common.advancedfilter.AdvancedResourceContainerImpl;
import com.ultramega.cabletiers.common.advancedfilter.TagFilterWithFuzzyMode;
import com.ultramega.cabletiers.common.importer.TieredImporterContainerMenu;
import com.ultramega.cabletiers.common.importer.TieredImporterNetworkNode;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.support.AbstractTieredCableLikeBlockEntity;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractTieredImporterBlockEntity
extends AbstractTieredCableLikeBlockEntity<TieredImporterNetworkNode>
implements NetworkNodeExtendedMenuProvider<ResourceContainerData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTieredImporterBlockEntity.class);

    protected AbstractTieredImporterBlockEntity(final CableTiers tier, BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getTieredImporters(tier), pos, state, new TieredImporterNetworkNode(tier.getEnergyUsage(CableType.IMPORTER)), tier, CableType.IMPORTER);
        this.filter = TagFilterWithFuzzyMode.createAndListenForUniqueFilters(AdvancedResourceContainerImpl.createForFilter(tier), this::setChanged, this::setFilters);
        ((TieredImporterNetworkNode)this.mainNetworkNode).setNormalizer(this.filter.createNormalizer());
        this.upgradeContainer = new UpgradeContainer(this, AbstractTieredImporterBlockEntity.getUpgradeDestination(tier), (c, upgradeEnergyUsage) -> {
            ((TieredImporterNetworkNode)this.mainNetworkNode).setEnergyUsage(tier.getEnergyUsage(CableType.IMPORTER) + upgradeEnergyUsage);
            this.setChanged();
            Level patt0$temp = this.level;
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                this.initialize(serverLevel);
            }
        }){

            public boolean has(UpgradeItem upgradeItem) {
                if (tier.hasIntegratedStackUpgrade(CableType.IMPORTER) && upgradeItem == Items.INSTANCE.getStackUpgrade()) {
                    return true;
                }
                return super.has(upgradeItem);
            }

            public int getAmount(UpgradeItem upgradeItem) {
                if (tier == CableTiers.CREATIVE && upgradeItem == Items.INSTANCE.getSpeedUpgrade()) {
                    return 4;
                }
                return super.getAmount(upgradeItem);
            }
        };
        this.ticker = this.upgradeContainer.getTicker();
    }

    public static UpgradeDestination getUpgradeDestination(CableTiers tier) {
        return tier == CableTiers.CREATIVE ? TieredUpgradeDestinations.IMPORTER_NO_STACK_SPEED : (tier.hasIntegratedStackUpgrade(CableType.IMPORTER) ? TieredUpgradeDestinations.IMPORTER_NO_STACK : UpgradeDestinations.IMPORTER);
    }

    void setFilters(Set<ResourceKey> filters, Set<TagKey<?>> tagFilters) {
        ((TieredImporterNetworkNode)this.mainNetworkNode).setFilters(filters, tagFilters);
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
    }

    FilterMode getFilterMode() {
        return ((TieredImporterNetworkNode)this.mainNetworkNode).getFilterMode();
    }

    void setFilterMode(FilterMode mode) {
        ((TieredImporterNetworkNode)this.mainNetworkNode).setFilterMode(mode);
        this.setChanged();
    }

    @Override
    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        tag.putInt("fim", FilterModeSettings.getFilterMode((FilterMode)((TieredImporterNetworkNode)this.mainNetworkNode).getFilterMode()));
    }

    @Override
    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        if (tag.contains("fim")) {
            ((TieredImporterNetworkNode)this.mainNetworkNode).setFilterMode(FilterModeSettings.getFilterMode((int)tag.getInt("fim")));
        }
    }

    protected void initialize(ServerLevel level, Direction direction) {
        super.initialize(level, direction);
        ImporterTransferStrategy strategy = this.createStrategy(level, direction);
        LOGGER.debug("Initialized importer at {} with strategy {}", (Object)this.worldPosition, (Object)strategy);
        ((TieredImporterNetworkNode)this.mainNetworkNode).setTransferStrategy(strategy);
    }

    private ImporterTransferStrategy createStrategy(ServerLevel serverLevel, Direction direction) {
        Direction incomingDirection = direction.getOpposite();
        BlockPos sourcePosition = this.worldPosition.relative(direction);
        List factories = RefinedStorageApi.INSTANCE.getImporterTransferStrategyRegistry().getAll();
        return new CompositeImporterTransferStrategy(factories.stream().map(factory -> factory.create(serverLevel, sourcePosition, incomingDirection, (UpgradeState)this.upgradeContainer)).toList());
    }

    public ResourceContainerData getMenuData() {
        return ResourceContainerData.of((ResourceContainer)this.filter.getFilterContainer());
    }

    public StreamEncoder<RegistryFriendlyByteBuf, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    public Component getName() {
        return this.overrideName((Component)this.tier.getContentName(CableType.IMPORTER));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        this.setInContainerMenu(true);
        return new TieredImporterContainerMenu(syncId, player, this, (ResourceContainer)this.filter.getFilterContainer(), this.upgradeContainer, this.tier);
    }
}

